/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.io.TemporaryHeapBuffer;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.Futures;

public class OutputBuffer {
    protected static final Logger LOGGER = Grizzly.logger(OutputBuffer.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_CHAR_BUFFER_SIZE = 65537;
    private static final boolean IS_BLOCKING = Boolean.getBoolean(OutputBuffer.class.getName() + ".isBlocking");
    private FilterChainContext ctx;
    private CompositeBuffer compositeBuffer;
    private Buffer currentBuffer;
    private final TemporaryHeapBuffer temporaryWriteBuffer = new TemporaryHeapBuffer();
    private final ByteArrayCloner cloner = new ByteArrayCloner();
    private final List<LifeCycleListener> lifeCycleListeners = new ArrayList<LifeCycleListener>(2);
    private boolean committed;
    private boolean finished;
    private boolean closed;
    private CharsetEncoder encoder;
    private final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private char[] charsArray;
    private int charsArrayLength;
    private CharBuffer charsBuffer;
    private MemoryManager memoryManager;
    private WriteHandler handler;
    private final AtomicReference<Throwable> asyncError = new AtomicReference();
    private InternalWriteHandler asyncWriteHandler;
    private AsyncQueueWriter asyncWriter;
    private boolean fileTransferRequested;
    private int bufferSize = 8192;
    protected boolean sendfileEnabled;
    private HttpHeader outputHeader;
    private final CompletionHandler<WriteResult> onAsyncErrorCompletionHandler = new OnErrorCompletionHandler();
    private final CompletionHandler<WriteResult> onWritePossibleCompletionHandler = new OnWritePossibleCompletionHandler();
    private boolean isNonBlockingWriteGuaranteed;
    private boolean isLastWriteNonBlocking;
    private HttpContext httpContext;

    public void initialize(HttpHeader outputHeader, boolean sendfileEnabled, FilterChainContext ctx) {
        this.outputHeader = outputHeader;
        this.sendfileEnabled = sendfileEnabled;
        this.ctx = ctx;
        this.httpContext = HttpContext.get(ctx);
        this.memoryManager = ctx.getMemoryManager();
        Connection c = ctx.getConnection();
        this.asyncWriter = (AsyncQueueWriter)c.getTransport().getWriter(false);
    }

    public boolean isAsyncEnabled() {
        return true;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
    }

    public void prepareCharacterEncoder() {
        this.getEncoder();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void registerLifeCycleListener(LifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public boolean removeLifeCycleListener(LifeCycleListener listener) {
        return this.lifeCycleListeners.remove(listener);
    }

    public void setBufferSize(int bufferSize) {
        if (!this.committed && this.currentBuffer == null) {
            this.bufferSize = bufferSize;
        }
        if (this.charsArray != null && this.charsArray.length < bufferSize) {
            char[] newCharsArray = new char[bufferSize];
            System.arraycopy(this.charsArray, 0, newCharsArray, 0, this.charsArrayLength);
            this.charsBuffer = CharBuffer.wrap(newCharsArray);
            this.charsArray = newCharsArray;
        }
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.compositeBuffer = null;
        if (this.currentBuffer != null) {
            this.currentBuffer.clear();
        }
        this.charsArrayLength = 0;
        this.encoder = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getBufferedDataSize() {
        int size = 0;
        if (this.compositeBuffer != null) {
            size += this.compositeBuffer.remaining();
        }
        if (this.currentBuffer != null) {
            size += this.currentBuffer.position();
        }
        return size += this.charsArrayLength << 1;
    }

    public void recycle() {
        this.outputHeader = null;
        if (this.compositeBuffer != null) {
            this.compositeBuffer.dispose();
            this.compositeBuffer = null;
        }
        if (this.currentBuffer != null) {
            this.currentBuffer.dispose();
            this.currentBuffer = null;
        }
        this.temporaryWriteBuffer.recycle();
        if (this.charsArray != null) {
            this.charsArrayLength = 0;
            if (this.charsArray.length < 65537) {
                this.charsBuffer.clear();
            } else {
                this.charsBuffer = null;
                this.charsArray = null;
            }
        }
        this.fileTransferRequested = false;
        this.encoder = null;
        this.ctx = null;
        this.httpContext = null;
        this.memoryManager = null;
        this.handler = null;
        this.isNonBlockingWriteGuaranteed = false;
        this.isLastWriteNonBlocking = false;
        this.asyncError.set(null);
        this.asyncWriteHandler = null;
        this.asyncWriter = null;
        this.committed = false;
        this.finished = false;
        this.closed = false;
        this.lifeCycleListeners.clear();
    }

    public void endRequest() throws IOException {
        this.handleAsyncErrors();
        if (this.finished) {
            return;
        }
        InternalWriteHandler asyncWriteQueueHandlerLocal = this.asyncWriteHandler;
        if (asyncWriteQueueHandlerLocal != null) {
            this.asyncWriteHandler = null;
            asyncWriteQueueHandlerLocal.done = true;
        }
        if (!this.closed) {
            this.close();
        }
        if (this.ctx != null) {
            this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
        }
        this.finished = true;
    }

    public void acknowledge() throws IOException {
        this.ctx.write((Object)this.outputHeader, IS_BLOCKING);
    }

    public void writeChar(int c) throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        if (this.charsArrayLength == this.charsArray.length) {
            this.flushCharsToBuf(true);
        }
        this.charsArray[this.charsArrayLength++] = (char)c;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        int remaining = this.charsArray.length - this.charsArrayLength;
        if (len <= remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, len);
            this.charsArrayLength += len;
        } else if (len - remaining < remaining) {
            System.arraycopy(cbuf, off, this.charsArray, this.charsArrayLength, remaining);
            this.charsArrayLength += remaining;
            this.flushCharsToBuf(true);
            System.arraycopy(cbuf, off + remaining, this.charsArray, 0, len - remaining);
            this.charsArrayLength = len - remaining;
        } else {
            this.flushCharsToBuf(false);
            this.flushCharsToBuf(CharBuffer.wrap(cbuf, off, len), true);
        }
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCharBuffer();
        if (this.charsArray.length - this.charsArrayLength >= len) {
            str.getChars(off, off + len, this.charsArray, this.charsArrayLength);
            this.charsArrayLength += len;
            return;
        }
        int offLocal = off;
        int lenLocal = len;
        do {
            int remaining = this.charsArray.length - this.charsArrayLength;
            int workingLen = Math.min(lenLocal, remaining);
            str.getChars(offLocal, offLocal + workingLen, this.charsArray, this.charsArrayLength);
            this.charsArrayLength += workingLen;
            offLocal += workingLen;
            if ((lenLocal -= workingLen) <= 0) continue;
            this.flushCharsToBuf(false);
        } while (lenLocal > 0);
        this.flushBinaryBuffersIfNeeded();
    }

    public void writeByte(int b) throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.updateNonBlockingStatus();
        this.checkCurrentBuffer();
        if (!this.currentBuffer.hasRemaining()) {
            if (this.canWritePayloadChunk()) {
                this.doCommit();
                this.flushBinaryBuffers(false);
                this.checkCurrentBuffer();
                this.blockAfterWriteIfNeeded();
            } else {
                this.finishCurrentBuffer();
                this.checkCurrentBuffer();
            }
        }
        this.currentBuffer.put((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void sendfile(File file, CompletionHandler<WriteResult> handler) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null");
        }
        this.sendfile(file, 0L, file.length(), handler);
    }

    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        if (this.fileTransferRequested) {
            throw new IllegalStateException("Only one file transfer allowed per request");
        }
        this.reset();
        FileTransfer f = new FileTransfer(file, offset, length);
        this.fileTransferRequested = true;
        this.outputHeader.setContentLengthLong(f.remaining());
        if (this.outputHeader.getContentType() == null) {
            this.outputHeader.setContentType(MimeType.getByFilename(file.getName()));
        }
        this.outputHeader.setHeader(Header.ContentEncoding, "identity");
        try {
            this.flush();
        }
        catch (IOException e) {
            if (handler != null) {
                handler.failed((Throwable)e);
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, String.format("Failed to transfer file %s.  Cause: %s.", file.getAbsolutePath(), e.getMessage()), e);
            }
            return;
        }
        this.ctx.write((Object)f, handler);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.handleAsyncErrors();
        if (this.closed || len == 0) {
            return;
        }
        this.updateNonBlockingStatus();
        if (this.bufferSize >= len && (this.currentBuffer == null || this.currentBuffer.remaining() >= len)) {
            this.checkCurrentBuffer();
            assert (this.currentBuffer != null);
            this.currentBuffer.put(b, off, len);
        } else if (this.canWritePayloadChunk()) {
            this.temporaryWriteBuffer.reset(b, off, len);
            this.finishCurrentBuffer();
            this.doCommit();
            if (this.compositeBuffer != null) {
                this.compositeBuffer.append((Object)this.temporaryWriteBuffer);
                this.flushBuffer((Buffer)this.compositeBuffer, false, this.cloner);
                this.compositeBuffer = null;
            } else {
                this.flushBuffer((Buffer)this.temporaryWriteBuffer, false, this.cloner);
            }
            this.blockAfterWriteIfNeeded();
        } else {
            this.finishCurrentBuffer();
            Buffer cloneBuffer = this.memoryManager.allocate(len);
            cloneBuffer.put(b, off, len);
            cloneBuffer.flip();
            this.checkCompositeBuffer();
            this.compositeBuffer.append((Object)cloneBuffer);
        }
    }

    public void close() throws IOException {
        this.handleAsyncErrors();
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(true) && (isJustCommitted || this.outputHeader.isChunked())) {
            this.forceCommitHeaders(true);
        }
        this.blockAfterWriteIfNeeded();
    }

    public void flush() throws IOException {
        this.handleAsyncErrors();
        boolean isJustCommitted = this.doCommit();
        if (!this.flushAllBuffers(false) && isJustCommitted) {
            this.forceCommitHeaders(false);
        }
        this.blockAfterWriteIfNeeded();
    }

    public void writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Buffer w = Buffers.wrap((MemoryManager)this.memoryManager, (ByteBuffer)byteBuffer);
        w.allowBufferDispose(false);
        this.writeBuffer(w);
    }

    public void writeBuffer(Buffer buffer) throws IOException {
        this.handleAsyncErrors();
        this.updateNonBlockingStatus();
        this.finishCurrentBuffer();
        this.checkCompositeBuffer();
        this.compositeBuffer.append((Object)buffer);
        if (this.canWritePayloadChunk() && this.compositeBuffer.remaining() > this.bufferSize) {
            this.flush();
        }
    }

    @Deprecated
    public boolean canWriteChar(int length) {
        return this.canWrite();
    }

    public boolean canWrite(int length) {
        return this.canWrite();
    }

    public boolean canWrite() {
        if (IS_BLOCKING || this.isNonBlockingWriteGuaranteed) {
            return true;
        }
        if (this.httpContext.getOutputSink().canWrite()) {
            this.isNonBlockingWriteGuaranteed = true;
            return true;
        }
        return false;
    }

    public void notifyCanWrite(WriteHandler handler, int length) {
        this.notifyCanWrite(handler);
    }

    public void notifyCanWrite(WriteHandler handler) {
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to set a new handler before the existing handler has been notified.");
        }
        Throwable asyncException = this.asyncError.get();
        if (asyncException != null) {
            handler.onError((Throwable)Exceptions.makeIOException((Throwable)asyncException));
            return;
        }
        Connection c = this.ctx.getConnection();
        this.handler = handler;
        if (this.isNonBlockingWriteGuaranteed || this.canWrite()) {
            Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
            if (!reentrant.isMaxReentrantsReached()) {
                this.notifyWritePossible();
            } else {
                this.notifyWritePossibleAsync(c);
            }
            return;
        }
        assert (!IS_BLOCKING);
        TaskQueue taskQueue = ((NIOConnection)c).getAsyncWriteQueue();
        if (this.asyncWriteHandler == null) {
            this.asyncWriteHandler = new InternalWriteHandler();
        }
        try {
            this.httpContext.getOutputSink().notifyCanWrite((WriteHandler)this.asyncWriteHandler);
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    private void notifyWritePossibleAsync(Connection c) {
        this.asyncWriter.write(c, (WritableMessage)Buffers.EMPTY_BUFFER, this.onWritePossibleCompletionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWritePossible() {
        Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
        WriteHandler localHandler = this.handler;
        if (localHandler != null) {
            try {
                this.handler = null;
                reentrant.inc();
                this.isNonBlockingWriteGuaranteed = true;
                localHandler.onWritePossible();
            }
            catch (Throwable t) {
                localHandler.onError(t);
            }
            finally {
                reentrant.dec();
            }
        }
    }

    private boolean canWritePayloadChunk() {
        return this.outputHeader.isChunkingAllowed() || this.outputHeader.getContentLength() != -1L;
    }

    private void handleAsyncErrors() throws IOException {
        Throwable t = this.asyncError.get();
        if (t != null) {
            throw Exceptions.makeIOException((Throwable)t);
        }
    }

    private void blockAfterWriteIfNeeded() throws IOException {
        if (IS_BLOCKING || this.isNonBlockingWriteGuaranteed || this.isLastWriteNonBlocking) {
            return;
        }
        if (this.httpContext.getOutputSink().canWrite()) {
            return;
        }
        final FutureImpl future = Futures.createSafeFuture();
        this.httpContext.getOutputSink().notifyCanWrite(new WriteHandler(){

            public void onWritePossible() throws Exception {
                future.result((Object)Boolean.TRUE);
            }

            public void onError(Throwable t) {
                future.failure((Throwable)Exceptions.makeIOException((Throwable)t));
            }
        });
        try {
            long writeTimeout = this.ctx.getConnection().getReadTimeout(TimeUnit.MILLISECONDS);
            if (writeTimeout >= 0L) {
                future.get(writeTimeout, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw Exceptions.makeIOException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw Exceptions.makeIOException((Throwable)e);
        }
    }

    private boolean flushAllBuffers(boolean isLast) throws IOException {
        if (this.charsArrayLength > 0) {
            this.flushCharsToBuf(false);
        }
        return this.flushBinaryBuffers(isLast);
    }

    private boolean flushBinaryBuffers(boolean isLast) throws IOException {
        CompositeBuffer bufferToFlush;
        boolean isFlushComposite;
        if (!this.outputHeader.isChunkingAllowed() && this.outputHeader.getContentLength() == -1L) {
            if (!isLast) {
                return false;
            }
            this.outputHeader.setContentLength(this.getBufferedDataSize());
        }
        boolean bl = isFlushComposite = this.compositeBuffer != null && this.compositeBuffer.hasRemaining();
        if (isFlushComposite) {
            this.finishCurrentBuffer();
            bufferToFlush = this.compositeBuffer;
            this.compositeBuffer = null;
        } else if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            bufferToFlush = this.currentBuffer;
            this.currentBuffer = null;
        } else {
            bufferToFlush = null;
        }
        if (bufferToFlush != null) {
            this.flushBuffer((Buffer)bufferToFlush, isLast, null);
            return true;
        }
        return false;
    }

    private void flushBuffer(Buffer bufferToFlush, boolean isLast, MessageCloner<Buffer> messageCloner) throws IOException {
        HttpContent.Builder builder = this.outputHeader.httpContentBuilder();
        ((HttpContent.Builder)builder.content(bufferToFlush)).last(isLast);
        this.ctx.write(null, (Object)builder.build(), this.onAsyncErrorCompletionHandler, messageCloner, IS_BLOCKING);
    }

    private void checkCharBuffer() {
        if (this.charsArray == null) {
            this.charsArray = new char[this.bufferSize];
            this.charsBuffer = CharBuffer.wrap(this.charsArray);
        }
    }

    private void checkCurrentBuffer() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.memoryManager.allocate(this.bufferSize);
            this.currentBuffer.allowBufferDispose(true);
        }
    }

    private void finishCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.position() > 0) {
            this.currentBuffer.trim();
            this.checkCompositeBuffer();
            this.compositeBuffer.append((Object)this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    private CharsetEncoder getEncoder() {
        if (this.encoder == null) {
            String encoding = this.outputHeader.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            this.encoder = this.encoders.get(encoding);
            if (this.encoder == null) {
                Charset cs = Charsets.lookupCharset((String)encoding);
                this.encoder = cs.newEncoder();
                this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.encoders.put(encoding, this.encoder);
            } else {
                this.encoder.reset();
            }
        }
        return this.encoder;
    }

    private boolean doCommit() throws IOException {
        if (!this.committed) {
            this.notifyCommit();
            this.committed = true;
            return true;
        }
        return false;
    }

    private void forceCommitHeaders(boolean isLast) throws IOException {
        if (isLast) {
            if (this.outputHeader != null) {
                HttpContent.Builder builder = this.outputHeader.httpContentBuilder();
                builder.last(true);
                this.ctx.write((Object)builder.build(), IS_BLOCKING);
            }
        } else {
            this.ctx.write((Object)this.outputHeader, IS_BLOCKING);
        }
    }

    private void checkCompositeBuffer() {
        if (this.compositeBuffer == null) {
            CompositeBuffer buffer = CompositeBuffer.newBuffer((MemoryManager)this.memoryManager);
            buffer.allowBufferDispose(true);
            buffer.allowInternalBuffersDispose(true);
            this.compositeBuffer = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCharsToBuf(boolean canFlushToNet) throws IOException {
        this.charsBuffer.limit(this.charsArrayLength);
        try {
            this.flushCharsToBuf(this.charsBuffer, canFlushToNet);
        }
        finally {
            this.charsArrayLength = 0;
            this.charsBuffer.clear();
        }
    }

    private void flushCharsToBuf(CharBuffer charBuf, boolean canFlushToNet) throws IOException {
        if (!charBuf.hasRemaining()) {
            return;
        }
        CharsetEncoder enc = this.getEncoder();
        this.checkCurrentBuffer();
        ByteBuffer currentByteBuffer = this.currentBuffer.toByteBuffer();
        int bufferPos = this.currentBuffer.position();
        int byteBufferPos = currentByteBuffer.position();
        CoderResult res = enc.encode(charBuf, currentByteBuffer, true);
        this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
        while (res == CoderResult.OVERFLOW) {
            this.checkCurrentBuffer();
            currentByteBuffer = this.currentBuffer.toByteBuffer();
            bufferPos = this.currentBuffer.position();
            byteBufferPos = currentByteBuffer.position();
            res = enc.encode(charBuf, currentByteBuffer, true);
            this.currentBuffer.position(bufferPos + (currentByteBuffer.position() - byteBufferPos));
            if (res != CoderResult.OVERFLOW) continue;
            this.finishCurrentBuffer();
        }
        if (res != CoderResult.UNDERFLOW) {
            throw new IOException("Encoding error");
        }
        if (canFlushToNet) {
            this.flushBinaryBuffersIfNeeded();
        }
    }

    private void flushBinaryBuffersIfNeeded() throws IOException {
        if (this.compositeBuffer != null) {
            this.doCommit();
            this.flushBinaryBuffers(false);
            this.blockAfterWriteIfNeeded();
        }
    }

    private void notifyCommit() throws IOException {
        int len = this.lifeCycleListeners.size();
        for (int i = 0; i < len; ++i) {
            this.lifeCycleListeners.get(i).onCommit();
        }
    }

    private void updateNonBlockingStatus() {
        this.isLastWriteNonBlocking = this.isNonBlockingWriteGuaranteed;
        this.isNonBlockingWriteGuaranteed = false;
    }

    private final class InternalWriteHandler
    implements WriteHandler {
        private volatile boolean done;

        private InternalWriteHandler() {
        }

        public void onWritePossible() throws Exception {
            if (!this.done) {
                try {
                    Writer.Reentrant reentrant = Writer.Reentrant.getWriteReentrant();
                    if (!reentrant.isMaxReentrantsReached()) {
                        OutputBuffer.this.notifyWritePossible();
                    } else {
                        OutputBuffer.this.notifyWritePossibleAsync(OutputBuffer.this.ctx.getConnection());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onError(Throwable t) {
            WriteHandler localHandler;
            if (!this.done && (localHandler = OutputBuffer.this.handler) != null) {
                try {
                    OutputBuffer.this.handler = null;
                    localHandler.onError(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private final class OnWritePossibleCompletionHandler
    extends OnErrorCompletionHandler {
        private OnWritePossibleCompletionHandler() {
        }

        public void completed(WriteResult result) {
            OutputBuffer.this.notifyWritePossible();
        }
    }

    private class OnErrorCompletionHandler
    extends EmptyCompletionHandler<WriteResult> {
        private OnErrorCompletionHandler() {
        }

        public void failed(Throwable throwable) {
            OutputBuffer.this.asyncError.compareAndSet(null, throwable);
            WriteHandler localHandler = OutputBuffer.this.handler;
            OutputBuffer.this.handler = null;
            if (localHandler != null) {
                localHandler.onError(throwable);
            }
        }
    }

    public static interface LifeCycleListener {
        public void onCommit() throws IOException;
    }

    private final class ByteArrayCloner
    implements MessageCloner<Buffer> {
        private ByteArrayCloner() {
        }

        public Buffer clone(Connection connection, Buffer originalMessage) {
            if (OutputBuffer.this.temporaryWriteBuffer.isDisposed()) {
                return originalMessage;
            }
            if (originalMessage.isComposite()) {
                CompositeBuffer compositeBuffer = (CompositeBuffer)originalMessage;
                compositeBuffer.shrink();
                if (!OutputBuffer.this.temporaryWriteBuffer.isDisposed()) {
                    if (compositeBuffer.remaining() == OutputBuffer.this.temporaryWriteBuffer.remaining()) {
                        compositeBuffer.allowInternalBuffersDispose(false);
                        compositeBuffer.tryDispose();
                        return OutputBuffer.this.temporaryWriteBuffer.cloneContent();
                    }
                    compositeBuffer.replace((Buffer)OutputBuffer.this.temporaryWriteBuffer, OutputBuffer.this.temporaryWriteBuffer.cloneContent());
                }
                return originalMessage;
            }
            return OutputBuffer.this.temporaryWriteBuffer.cloneContent();
        }
    }
}

