/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.utils.Charsets;

public abstract class HttpHeader
extends HttpPacket
implements MimeHeadersPacket,
AttributeStorage {
    private static final byte[] CHUNKED_ENCODING_BYTES = "chunked".getBytes(Charsets.ASCII_CHARSET);
    protected boolean isCommitted;
    protected final MimeHeaders headers;
    protected final DataChunk protocolC = DataChunk.newInstance();
    protected Protocol parsedProtocol;
    protected boolean isChunked;
    private final byte[] tmpContentLengthBuffer = new byte[20];
    private final byte[] tmpHeaderEncodingBuffer = new byte[512];
    protected long contentLength = -1L;
    protected final ContentType.SettableContentType contentType = ContentType.newSettableContentType();
    protected boolean isExpectContent = true;
    protected boolean isSkipRemainder;
    protected boolean isContentBroken;
    protected boolean secure;
    private boolean isIgnoreContentModifiers;
    protected final DataChunk upgrade = DataChunk.newInstance();
    private TransferEncoding transferEncoding;
    private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>(2);
    private boolean isContentEncodingsSelected;
    private final AttributeHolder attributes = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createUnsafeAttributeHolder();
    private AttributeHolder activeAttributes;
    Buffer headerBuffer;
    private boolean chunkingAllowed;

    public HttpHeader() {
        this(new MimeHeaders());
    }

    protected HttpHeader(MimeHeaders headers) {
        this.headers = headers;
    }

    void setHeaderBuffer(Buffer headerBuffer) {
        this.headerBuffer = headerBuffer;
    }

    public AttributeHolder getAttributes() {
        if (this.activeAttributes == null) {
            this.activeAttributes = this.attributes;
        }
        return this.activeAttributes;
    }

    public abstract boolean isRequest();

    @Override
    public final boolean isHeader() {
        return true;
    }

    @Override
    public HttpHeader getHttpHeader() {
        return this;
    }

    public abstract ProcessingState getProcessingState();

    protected HttpPacketParsing getParsingState() {
        return null;
    }

    protected void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add(contentEncoding);
    }

    protected List<ContentEncoding> getContentEncodings(boolean isModifiable) {
        if (isModifiable) {
            return this.contentEncodings;
        }
        return Collections.unmodifiableList(this.contentEncodings);
    }

    public List<ContentEncoding> getContentEncodings() {
        return this.getContentEncodings(false);
    }

    protected final boolean isContentEncodingsSelected() {
        return this.isContentEncodingsSelected;
    }

    protected final void setContentEncodingsSelected(boolean isContentEncodingsSelected) {
        this.isContentEncodingsSelected = isContentEncodingsSelected;
    }

    public TransferEncoding getTransferEncoding() {
        return this.transferEncoding;
    }

    protected void setTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        if (this.getProtocol().compareTo(Protocol.HTTP_1_1) >= 0) {
            this.isChunked = isChunked;
            if (isChunked) {
                this.headers.removeHeader(Header.ContentLength);
            }
        } else {
            this.isChunked = false;
        }
    }

    public boolean isExpectContent() {
        return this.isExpectContent;
    }

    public void setExpectContent(boolean isExpectContent) {
        this.isExpectContent = isExpectContent;
    }

    public boolean isSkipRemainder() {
        return this.isSkipRemainder;
    }

    public void setSkipRemainder(boolean isSkipRemainder) {
        this.isSkipRemainder = isSkipRemainder;
    }

    public boolean isContentBroken() {
        return this.isContentBroken;
    }

    public void setContentBroken(boolean isBroken) {
        this.isContentBroken = isBroken;
    }

    public final String getUpgrade() {
        return this.upgrade.toString();
    }

    public DataChunk getUpgradeDC() {
        return this.upgrade;
    }

    public final void setUpgrade(String upgrade) {
        this.upgrade.setString(upgrade);
    }

    public boolean isUpgrade() {
        return !this.getUpgradeDC().isNull();
    }

    protected void makeUpgradeHeader() {
        if (!this.upgrade.isNull()) {
            this.headers.setValue(Header.Upgrade).set(this.upgrade);
        }
    }

    public boolean isIgnoreContentModifiers() {
        return this.isIgnoreContentModifiers;
    }

    public void setIgnoreContentModifiers(boolean isIgnoreContentModifiers) {
        this.isIgnoreContentModifiers = isIgnoreContentModifiers;
    }

    protected void makeContentLengthHeader(long defaultLength) {
        if (this.contentLength != -1L) {
            int start = HttpUtils.longToBuffer(this.contentLength, this.tmpContentLengthBuffer);
            this.headers.setValue(Header.ContentLength).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
        } else if (defaultLength != -1L) {
            int start = HttpUtils.longToBuffer(defaultLength, this.tmpContentLengthBuffer);
            int idx = this.headers.indexOf(Header.ContentLength, 0);
            if (idx == -1) {
                this.headers.addValue(Header.ContentLength).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
            } else if (this.headers.getValue(idx).isNull()) {
                this.headers.getValue(idx).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
            }
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int len) {
        this.setContentLengthLong(len);
    }

    public void setContentLengthLong(long contentLength) {
        boolean negativeLength;
        this.contentLength = contentLength;
        boolean bl = negativeLength = contentLength < 0L;
        if (negativeLength) {
            this.headers.removeHeader(Header.ContentLength);
        }
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    protected void makeTransferEncodingHeader(String defaultValue) {
        int idx = this.headers.indexOf(Header.TransferEncoding, 0);
        if (idx == -1) {
            this.headers.addValue(Header.TransferEncoding).setBytes(CHUNKED_ENCODING_BYTES);
        }
    }

    protected void extractContentEncoding(DataChunk value) {
        int idx = this.headers.indexOf(Header.ContentEncoding, 0);
        if (idx != -1) {
            this.headers.setSerialized(idx, true);
            value.set(this.headers.getValue(idx));
        }
    }

    public String getCharacterEncoding() {
        return this.contentType.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        this.contentType.setCharacterEncoding(charset);
    }

    public boolean isChunkingAllowed() {
        return this.chunkingAllowed;
    }

    public void setChunkingAllowed(boolean chunkingAllowed) {
        this.chunkingAllowed = chunkingAllowed;
    }

    public boolean isContentTypeSet() {
        return this.contentType.isMimeTypeSet() || this.headers.getValue(Header.ContentType) != null;
    }

    public String getContentType() {
        return this.contentType.get();
    }

    public void setContentType(String contentType) {
        this.contentType.set(contentType);
    }

    public void setContentType(ContentType contentType) {
        this.contentType.set(contentType);
    }

    protected ContentType getContentTypeHolder() {
        return this.contentType;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null ? result : this.headers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        if (header == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null ? result : this.headers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void setHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        value.serializeToDataChunk(this.headers.setValue(name));
    }

    @Override
    public void setHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        this.headers.setValue(header).setString(value);
    }

    @Override
    public void setHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        value.serializeToDataChunk(this.headers.setValue(header));
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        value.serializeToDataChunk(this.headers.setValue(name));
    }

    @Override
    public void addHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        this.headers.addValue(header).setString(value);
    }

    @Override
    public void addHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        value.serializeToDataChunk(this.headers.setValue(header));
    }

    @Override
    public boolean containsHeader(String name) {
        if (name == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null || this.headers.getHeader(name) != null;
    }

    @Override
    public boolean containsHeader(Header header) {
        if (header == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null || this.headers.getHeader(header) != null;
    }

    public DataChunk getProtocolDC() {
        this.parsedProtocol = null;
        return this.protocolC;
    }

    public String getProtocolString() {
        if (this.parsedProtocol == null) {
            return this.getProtocolDC().toString();
        }
        return this.parsedProtocol.getProtocolString();
    }

    public Protocol getProtocol() {
        if (this.parsedProtocol != null) {
            return this.parsedProtocol;
        }
        this.parsedProtocol = Protocol.valueOf(this.protocolC);
        return this.parsedProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.parsedProtocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final HttpContent.Builder httpContentBuilder() {
        return HttpContent.builder(this);
    }

    public HttpTrailer.Builder httpTrailerBuilder() {
        return HttpTrailer.builder(this);
    }

    protected void reset() {
        this.isContentEncodingsSelected = false;
        this.secure = false;
        this.isSkipRemainder = false;
        this.isContentBroken = false;
        if (this.activeAttributes != null) {
            this.activeAttributes.recycle();
            this.activeAttributes = null;
        }
        this.protocolC.recycle();
        this.parsedProtocol = null;
        this.contentEncodings.clear();
        this.headers.clear();
        this.isCommitted = false;
        this.isChunked = false;
        this.contentLength = -1L;
        this.contentType.reset();
        this.chunkingAllowed = false;
        this.transferEncoding = null;
        this.isExpectContent = true;
        this.upgrade.recycle();
        this.isIgnoreContentModifiers = false;
        if (this.headerBuffer != null) {
            this.headerBuffer.dispose();
            this.headerBuffer = null;
        }
    }

    public void recycle() {
        this.reset();
    }

    private final String handleGetSpecialHeader(String name) {
        return HttpHeader.isSpecialHeader(name) ? this.getValueBasedOnHeader(name) : null;
    }

    private final String handleGetSpecialHeader(Header header) {
        return HttpHeader.isSpecialHeader(header.toString()) ? this.getValueBasedOnHeader(header) : null;
    }

    private final boolean handleSetSpecialHeaders(String name, String value) {
        return HttpHeader.isSpecialHeaderSet(name) && this.setValueBasedOnHeader(name, value);
    }

    private final boolean handleSetSpecialHeaders(String name, HeaderValue value) {
        return HttpHeader.isSpecialHeaderSet(name) && this.setValueBasedOnHeader(name, value.get());
    }

    private final boolean handleSetSpecialHeaders(Header header, String value) {
        return HttpHeader.isSpecialHeaderSet(header.toString()) && this.setValueBasedOnHeader(header, value);
    }

    private final boolean handleSetSpecialHeaders(Header header, HeaderValue value) {
        return HttpHeader.isSpecialHeaderSet(header.toString()) && this.setValueBasedOnHeader(header, value.get());
    }

    private static boolean isSpecialHeader(String name) {
        return HttpHeader.isSpecialHeader(name.charAt(0));
    }

    private static boolean isSpecialHeaderSet(String name) {
        char c = name.charAt(0);
        return HttpHeader.isSpecialHeader(c) || c == 'T' || c == 't';
    }

    private static boolean isSpecialHeader(char c) {
        return c == 'C' || c == 'c' || c == 'U' || c == 'u';
    }

    public byte[] getTempHeaderEncodingBuffer() {
        return this.tmpHeaderEncodingBuffer;
    }

    private String getValueBasedOnHeader(Header header) {
        if (Header.ContentType.equals((Object)header)) {
            String value = this.getContentType();
            if (value != null) {
                return value;
            }
        } else if (Header.ContentLength.equals((Object)header)) {
            long value = this.getContentLength();
            if (value >= 0L) {
                return Long.toString(value);
            }
        } else if (Header.Upgrade.equals((Object)header)) {
            return this.getUpgrade();
        }
        return null;
    }

    private String getValueBasedOnHeader(String name) {
        if (Header.ContentType.toString().equalsIgnoreCase(name)) {
            String value = this.getContentType();
            if (value != null) {
                return value;
            }
        } else if (Header.ContentLength.toString().equalsIgnoreCase(name)) {
            long value = this.getContentLength();
            if (value >= 0L) {
                return Long.toString(value);
            }
        } else if (Header.Upgrade.toString().equalsIgnoreCase(name)) {
            return this.getUpgrade();
        }
        return null;
    }

    private boolean setValueBasedOnHeader(String name, String value) {
        if (Header.ContentType.toString().equalsIgnoreCase(name)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.toString().equalsIgnoreCase(name)) {
            this.headers.removeHeader(Header.TransferEncoding);
            this.setChunked(false);
            return this.setContentLenth(value);
        }
        if (Header.Upgrade.toString().equalsIgnoreCase(name)) {
            this.setUpgrade(value);
        } else if (Header.TransferEncoding.toString().equalsIgnoreCase(name)) {
            if ("chunked".equalsIgnoreCase(value)) {
                this.setContentLengthLong(-1L);
                this.setChunked(true);
            }
            return true;
        }
        return false;
    }

    private boolean setValueBasedOnHeader(Header header, String value) {
        if (Header.ContentType.equals((Object)header)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.equals((Object)header)) {
            this.headers.removeHeader(Header.TransferEncoding);
            this.setChunked(false);
            return this.setContentLenth(value);
        }
        if (Header.Upgrade.equals((Object)header)) {
            this.setUpgrade(value);
        } else if (Header.TransferEncoding.equals((Object)header)) {
            if ("chunked".equalsIgnoreCase(value)) {
                this.setContentLengthLong(-1L);
                this.setChunked(true);
            }
            return true;
        }
        return false;
    }

    private boolean setContentLenth(String value) {
        try {
            long cLL = Long.parseLong(value);
            this.setContentLengthLong(cLL);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected void flushSpecialHeaders() {
        String ct;
        if (this.contentLength >= 0L) {
            this.headers.setValue(Header.ContentLength).setString(String.valueOf(this.contentLength));
        }
        if ((ct = this.getContentType()) != null) {
            this.headers.setValue(Header.ContentType).setString(String.valueOf(ct));
        }
        if (!this.upgrade.isNull()) {
            this.headers.setValue(Header.Upgrade).setString(this.upgrade.toString());
        }
    }

    public static abstract class Builder<T extends Builder> {
        protected Protocol protocol;
        protected String protocolString;
        protected Boolean chunked;
        protected Long contentLength;
        protected String contentType;
        protected String upgrade;
        protected MimeHeaders mimeHeaders;

        public final T protocol(Protocol protocol) {
            this.protocol = protocol;
            this.protocolString = null;
            return (T)this;
        }

        public final T protocol(String protocolString) {
            this.protocolString = protocolString;
            this.protocol = null;
            return (T)this;
        }

        public final T chunked(boolean chunked) {
            this.chunked = chunked;
            this.contentLength = null;
            return (T)this;
        }

        public final T contentLength(long contentLength) {
            this.contentLength = contentLength;
            this.chunked = null;
            return (T)this;
        }

        public final T contentType(String contentType) {
            this.contentType = contentType;
            return (T)this;
        }

        public final T upgrade(String upgrade) {
            this.upgrade = upgrade;
            return (T)this;
        }

        public final T header(String name, String value) {
            if (this.mimeHeaders == null) {
                this.mimeHeaders = new MimeHeaders();
            }
            this.mimeHeaders.addValue(name).setString(value);
            this.handleSpecialHeaderAdd(name, value);
            return (T)this;
        }

        public final T removeHeader(String header) {
            if (this.mimeHeaders != null) {
                this.mimeHeaders.removeHeader(header);
                this.handleSpecialHeaderRemove(header);
            }
            return (T)this;
        }

        public final T header(Header header, String value) {
            if (this.mimeHeaders == null) {
                this.mimeHeaders = new MimeHeaders();
            }
            this.mimeHeaders.addValue(header).setString(value);
            this.handleSpecialHeaderAdd(header.toString(), value);
            return (T)this;
        }

        public final T removeHeader(Header header) {
            if (this.mimeHeaders != null) {
                this.mimeHeaders.removeHeader(header);
                this.handleSpecialHeaderRemove(header.toString());
            }
            return (T)this;
        }

        public final T maxNumHeaders(int maxHeaders) {
            if (this.mimeHeaders == null) {
                this.mimeHeaders = new MimeHeaders();
            }
            this.mimeHeaders.setMaxNumHeaders(maxHeaders);
            return (T)this;
        }

        public HttpHeader build() {
            HttpHeader httpHeader = this.create();
            if (this.protocol != null) {
                httpHeader.setProtocol(this.protocol);
            }
            if (this.protocolString != null) {
                httpHeader.protocolC.setString(this.protocolString);
            }
            if (this.chunked != null) {
                httpHeader.setChunked(this.chunked);
            }
            if (this.contentLength != null) {
                httpHeader.setContentLengthLong(this.contentLength);
            }
            if (this.contentType != null) {
                httpHeader.setContentType(this.contentType);
            }
            if (this.upgrade != null) {
                httpHeader.setUpgrade(this.upgrade);
            }
            if (this.mimeHeaders != null && this.mimeHeaders.size() > 0) {
                httpHeader.getHeaders().copyFrom(this.mimeHeaders);
            }
            return httpHeader;
        }

        public void reset() {
            this.protocol = null;
            this.protocolString = null;
            this.chunked = null;
            this.contentLength = null;
            this.contentType = null;
            this.upgrade = null;
            this.mimeHeaders.recycle();
        }

        protected abstract HttpHeader create();

        private void handleSpecialHeaderAdd(String name, String value) {
            boolean isU;
            boolean isC;
            char c = name.charAt(0);
            boolean bl = isC = c == 'c' || c == 'C';
            if (isC && Header.ContentLength.toString().equals(name)) {
                this.contentLength = Long.parseLong(value);
                return;
            }
            boolean bl2 = isU = c == 'u' || c == 'U';
            if (isU && Header.Upgrade.toString().equals(name)) {
                this.upgrade = value;
            }
        }

        private void handleSpecialHeaderRemove(String name) {
            boolean isU;
            boolean isC;
            char c = name.charAt(0);
            boolean bl = isC = c == 'c' || c == 'C';
            if (isC && Header.ContentLength.toString().equals(name)) {
                this.contentLength = null;
                return;
            }
            boolean bl2 = isU = c == 'u' || c == 'U';
            if (isU && Header.Upgrade.toString().equals(name)) {
                this.upgrade = null;
            }
        }
    }
}

