/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.util.Iterator;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaderField;
import org.glassfish.grizzly.http.util.NamesIterator;
import org.glassfish.grizzly.http.util.ValuesIterator;

public class MimeHeaders {
    public static final int MAX_NUM_HEADERS_UNBOUNDED = -1;
    public static final int MAX_NUM_HEADERS_DEFAULT = 100;
    public static final int DEFAULT_HEADER_SIZE = 8;
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    int mark;
    private int maxNumHeaders = 100;
    private final Iterable<String> namesIterable = new Iterable<String>(){

        @Override
        public Iterator<String> iterator() {
            return new NamesIterator(MimeHeaders.this, false);
        }
    };

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].recycle();
        }
        this.count = 0;
        this.mark = 0;
    }

    public void mark() {
        if (this.mark == 0) {
            this.mark = this.count;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== MimeHeaders ===\n");
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.headers[i].nameB).append(" = ").append(this.headers[i].valueB).append('\n');
        }
        return sb.toString();
    }

    public void copyFrom(MimeHeaders source) {
        if (source == null || source.size() == 0) {
            return;
        }
        this.maxNumHeaders = source.maxNumHeaders;
        this.count = source.count;
        if (this.headers.length < this.count) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, this.headers.length);
            this.headers = tmp;
        }
        int len = source.count;
        for (int i = 0; i < len; ++i) {
            MimeHeaderField sourceField = source.headers[i];
            MimeHeaderField f = this.headers[i];
            if (f == null) {
                this.headers[i] = f = new MimeHeaderField();
            }
            if (sourceField.nameB.type == DataChunk.Type.Buffer) {
                MimeHeaders.copyBufferChunk(sourceField.nameB, f.nameB);
            } else {
                f.nameB.set(sourceField.nameB);
            }
            if (sourceField.valueB.type == DataChunk.Type.Buffer) {
                MimeHeaders.copyBufferChunk(sourceField.valueB, f.valueB);
                continue;
            }
            f.valueB.set(sourceField.valueB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyBufferChunk(DataChunk source, DataChunk dest) {
        BufferChunk bc = source.getBufferChunk();
        int l = bc.getLength();
        byte[] bytes = new byte[l];
        Buffer b = bc.getBuffer();
        int oldPos = b.position();
        try {
            b.position(bc.getStart());
            bc.getBuffer().get(bytes, 0, l);
            dest.setBytes(bytes);
        }
        finally {
            b.position(oldPos);
        }
    }

    public int size() {
        return this.count;
    }

    public int trailerSize() {
        if (this.mark > 0) {
            return this.count - this.mark;
        }
        return 0;
    }

    public DataChunk getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public DataChunk getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public boolean isSerialized(int n) {
        if (n >= 0 && n < this.count) {
            MimeHeaderField field = this.headers[n];
            return field.isSerialized();
        }
        return false;
    }

    public boolean setSerialized(int n, boolean newValue) {
        boolean value;
        if (n >= 0 && n < this.count) {
            MimeHeaderField field = this.headers[n];
            value = field.isSerialized();
            field.setSerialized(newValue);
        } else {
            value = true;
        }
        return value;
    }

    public int indexOf(String name, int fromIndex) {
        for (int i = fromIndex; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Header header, int fromIndex) {
        byte[] bytes = header.getLowerCaseBytes();
        for (int i = fromIndex; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Header header) {
        return this.indexOf(header, 0) >= 0;
    }

    public boolean contains(String header) {
        return this.indexOf(header, 0) >= 0;
    }

    public Iterable<String> names() {
        return this.namesIterable;
    }

    public Iterable<String> trailerNames() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new NamesIterator(MimeHeaders.this, true);
            }
        };
    }

    public Iterable<String> values(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name, false);
            }
        };
    }

    public Iterable<String> values(Header name) {
        return this.values(name.toString());
    }

    public Iterable<String> trailerValues(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name, true);
            }
        };
    }

    public Iterable<String> trailerValues(Header name) {
        return this.values(name.toString());
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        if (this.maxNumHeaders >= 0 && this.count == this.maxNumHeaders) {
            throw new MaxHeaderCountExceededException();
        }
        int len = this.headers.length;
        if (this.count >= len) {
            int newCount = this.count * 2;
            if (this.maxNumHeaders >= 0 && newCount > this.maxNumHeaders) {
                newCount = this.maxNumHeaders;
            }
            MimeHeaderField[] tmp = new MimeHeaderField[newCount];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public DataChunk addValue(String name) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk addValue(Header header) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk addValue(byte[] buffer, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBytes(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk addValue(Buffer buffer, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBuffer(buffer, startN, startN + len);
        return mhf.getValue();
    }

    public DataChunk setValue(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            for (int j = i + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCase(name)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk setValue(Header header) {
        byte[] bytes = header.getLowerCaseBytes();
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            for (int j = i + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setBytes(header.toByteArray());
        return mh.getValue();
    }

    public DataChunk getValue(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public DataChunk getValue(Header header) {
        byte[] bytes = header.getLowerCaseBytes();
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCaseLowerCase(bytes)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public String getHeader(String name) {
        DataChunk mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public String getHeader(Header header) {
        DataChunk mh = this.getValue(header);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeader(Header header) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(header.getBytes())) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeader(String name, String str) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name) || this.getValue(i) == null || this.getValue(i).toString() == null || !this.getValue(i).toString().contains(str)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeaderMatches(String name, String regex) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name) || this.getValue(i) == null || this.getValue(i).toString() == null || !this.getValue(i).toString().matches(regex)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeaderMatches(Header header, String regex) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCaseLowerCase(header.getLowerCaseBytes()) || this.getValue(i) == null || this.getValue(i).toString() == null || !this.getValue(i).toString().matches(regex)) continue;
            this.removeHeader(i--);
        }
    }

    void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }

    public void setMaxNumHeaders(int maxNumHeaders) {
        this.maxNumHeaders = maxNumHeaders;
    }

    public int getMaxNumHeaders() {
        return this.maxNumHeaders;
    }

    public class MaxHeaderCountExceededException
    extends IllegalStateException {
        public MaxHeaderCountExceededException() {
            super("Illegal attempt to exceed the configured maximum number of headers: " + MimeHeaders.this.maxNumHeaders);
        }
    }
}

