/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.MimeTrailers;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class HttpTrailer
extends HttpContent
implements MimeHeadersPacket {
    private static final ThreadCache.CachedTypeIndex<HttpTrailer> CACHE_IDX = ThreadCache.obtainIndex(HttpTrailer.class, (int)16);
    private MimeTrailers trailers = new MimeTrailers();

    public static boolean isTrailer(HttpContent httpContent) {
        return HttpTrailer.class.isAssignableFrom(httpContent.getClass());
    }

    public static HttpTrailer create() {
        return HttpTrailer.create(null);
    }

    public static HttpTrailer create(HttpHeader httpHeader) {
        HttpTrailer httpTrailer = (HttpTrailer)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpTrailer != null) {
            httpTrailer.httpHeader = httpHeader;
            return httpTrailer;
        }
        return new HttpTrailer(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return (Builder)new Builder().httpHeader(httpHeader);
    }

    protected HttpTrailer(HttpHeader httpHeader) {
        super(httpHeader);
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.trailers;
    }

    @Override
    public String getHeader(String name) {
        return this.trailers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        return this.trailers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.trailers.setValue(name).setString(value);
    }

    @Override
    public void setHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(name));
    }

    @Override
    public void setHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        this.trailers.setValue(header).setString(value);
    }

    @Override
    public void setHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(header));
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.trailers.addValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(name));
    }

    @Override
    public void addHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        DataChunk c = this.trailers.addValue(header);
        if (c != null) {
            c.setString(value);
        }
    }

    @Override
    public void addHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(header));
    }

    @Override
    public boolean containsHeader(String name) {
        return this.trailers.contains(name);
    }

    @Override
    public boolean containsHeader(Header header) {
        return this.trailers.contains(header);
    }

    protected void setTrailers(MimeTrailers trailers) {
        this.trailers = trailers;
    }

    @Override
    protected void reset() {
        this.trailers.recycle();
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        private MimeTrailers mimeTrailers;

        protected Builder() {
        }

        public final Builder headers(MimeTrailers mimeTrailers) {
            this.mimeTrailers = mimeTrailers;
            return this;
        }

        public final Builder header(String name, String value) {
            DataChunk c;
            if (this.mimeTrailers == null) {
                this.mimeTrailers = new MimeTrailers();
            }
            if ((c = this.mimeTrailers.addValue(name)) != null) {
                c.setString(value);
            }
            return this;
        }

        @Override
        public final HttpTrailer build() {
            HttpTrailer trailer = (HttpTrailer)super.build();
            if (this.mimeTrailers != null) {
                trailer.trailers = this.mimeTrailers;
            }
            return trailer;
        }

        @Override
        protected HttpContent create() {
            return HttpTrailer.create();
        }
    }
}

