/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http2.Http2Header;
import org.glassfish.grizzly.http2.Http2Response;
import org.glassfish.grizzly.http2.Http2Stream;

class Http2Request
extends HttpRequestPacket
implements Http2Header {
    private static final ThreadCache.CachedTypeIndex<Http2Request> CACHE_IDX = ThreadCache.obtainIndex(Http2Request.class, (int)2);
    private final ProcessingState processingState = new ProcessingState();
    private final Http2Response response = new Http2Response();
    private boolean contentTypeParsed;

    public static Http2Request create() {
        Http2Request http2Request = (Http2Request)ThreadCache.takeFromCache(CACHE_IDX);
        if (http2Request == null) {
            http2Request = new Http2Request();
        }
        return http2Request.init();
    }

    Http2Request() {
    }

    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    private Http2Request init() {
        this.setResponse(this.response);
        this.response.setRequest(this);
        this.setChunkingAllowed(true);
        this.response.setChunkingAllowed(true);
        return this;
    }

    @Override
    public Http2Stream getHttp2Stream() {
        return Http2Stream.getStreamFor((HttpHeader)this);
    }

    public String getCharacterEncoding() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        super.setCharacterEncoding(charset);
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            this.parseContentTypeHeader();
        }
        return super.getContentType();
    }

    private void parseContentTypeHeader() {
        DataChunk dc;
        this.contentTypeParsed = true;
        if (!this.contentType.isSet() && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
            this.setContentType(dc.toString());
        }
    }

    public Object getAttribute(String name) {
        if (Http2Stream.HTTP2_STREAM_ATTRIBUTE.equals(name)) {
            return this.response.getHttp2Stream();
        }
        return super.getAttribute(name);
    }

    protected void reset() {
        this.contentTypeParsed = false;
        this.processingState.recycle();
        super.reset();
    }

    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    @Override
    public void setExpectContent(boolean isExpectContent) {
        super.setExpectContent(isExpectContent);
    }

    protected void requiresAcknowledgement(boolean requiresAcknowledgement) {
        super.requiresAcknowledgement(requiresAcknowledgement);
    }
}

