/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.portunif.finders;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.portunif.PUContext;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLUtils;

public class SSLProtocolFinder
implements ProtocolFinder {
    private static final Logger LOGGER = Grizzly.logger(SSLProtocolFinder.class);
    private final SSLEngineConfigurator sslEngineConfigurator;

    public SSLProtocolFinder(SSLEngineConfigurator sslEngineConfigurator) {
        this.sslEngineConfigurator = sslEngineConfigurator;
    }

    @Override
    public ProtocolFinder.Result find(PUContext puContext, FilterChainContext ctx) {
        Buffer buffer = (Buffer)ctx.getMessage();
        try {
            int expectedLength = SSLUtils.getSSLPacketSize((Buffer)buffer);
            if (expectedLength == -1 || buffer.remaining() < expectedLength) {
                return ProtocolFinder.Result.NEED_MORE_DATA;
            }
        }
        catch (SSLException e) {
            LOGGER.log(Level.FINE, "Packet header is not SSL", e);
            return ProtocolFinder.Result.NOT_FOUND;
        }
        Connection connection = ctx.getConnection();
        SSLEngine sslEngine = this.sslEngineConfigurator.createSSLEngine();
        try {
            SSLUtils.handshakeUnwrap((Connection)connection, (SSLEngine)sslEngine, (Buffer)buffer);
            SSLUtils.setSSLEngine((AttributeStorage)connection, (SSLEngine)sslEngine);
            return ProtocolFinder.Result.FOUND;
        }
        catch (SSLException e) {
            LOGGER.log(Level.FINE, "SSL handshake attempt failed", e);
            return ProtocolFinder.Result.NOT_FOUND;
        }
    }
}

