/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.spdy;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.spdy.SessionOutputSink;
import org.glassfish.grizzly.spdy.SpdyHandlerFilter;
import org.glassfish.grizzly.spdy.SpdyRequest;
import org.glassfish.grizzly.spdy.SpdySessionException;
import org.glassfish.grizzly.spdy.SpdyStream;
import org.glassfish.grizzly.spdy.SpdyStreamException;
import org.glassfish.grizzly.spdy.SpdyVersion;
import org.glassfish.grizzly.spdy.compression.SpdyDeflaterOutputStream;
import org.glassfish.grizzly.spdy.compression.SpdyInflaterOutputStream;
import org.glassfish.grizzly.spdy.frames.GoAwayFrame;
import org.glassfish.grizzly.spdy.frames.RstStreamFrame;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.NullaryFunction;

public abstract class SpdySession {
    private static final Logger LOGGER = Grizzly.logger(SpdySession.class);
    private static final Level LOGGER_LEVEL = Level.FINE;
    private static final Attribute<SpdySession> SPDY_SESSION_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SpdySession.class.getName());
    private final boolean isServer;
    private final Connection<?> connection;
    private SpdyInflaterOutputStream inflaterOutputStream;
    private SpdyDeflaterOutputStream deflaterOutputStream;
    private DataOutputStream deflaterDataOutputStream;
    private final ReentrantLock deflaterLock = new ReentrantLock();
    private int deflaterCompressionLevel = -1;
    private int lastPeerStreamId;
    private int lastLocalStreamId;
    private final ReentrantLock newClientStreamLock = new ReentrantLock();
    private volatile FilterChain upstreamChain;
    private volatile FilterChain downstreamChain;
    private final Map<Integer, SpdyStream> streamsMap = DataStructures.getConcurrentMap();
    final List<SpdyStream> streamsToFlushInput = new ArrayList<SpdyStream>();
    private final Object sessionLock = new Object();
    private CloseType closeFlag;
    private int peerStreamWindowSize = 65536;
    private volatile int localStreamWindowSize = 65536;
    private volatile int localConnectionWindowSize = 65536;
    private volatile int localMaxConcurrentStreams = 100;
    private int peerMaxConcurrentStreams = 100;
    private final StreamBuilder streamBuilder = new StreamBuilder();
    private final SessionOutputSink outputSink;
    private final Holder<?> addressHolder;
    final SpdyHandlerFilter handlerFilter;

    public static SpdySession get(Connection connection) {
        return (SpdySession)SPDY_SESSION_ATTR.get((AttributeStorage)connection);
    }

    public static void bind(Connection connection, SpdySession spdySession) {
        SPDY_SESSION_ATTR.set((AttributeStorage)connection, (Object)spdySession);
    }

    public SpdySession(final Connection<?> connection, boolean isServer, SpdyHandlerFilter handlerFilter) {
        this.connection = connection;
        this.isServer = isServer;
        this.handlerFilter = handlerFilter;
        if (isServer) {
            this.lastLocalStreamId = 0;
            this.lastPeerStreamId = -1;
        } else {
            this.lastLocalStreamId = -1;
            this.lastPeerStreamId = 0;
        }
        this.addressHolder = Holder.lazyHolder((NullaryFunction)new NullaryFunction<Object>(){

            public Object evaluate() {
                return connection.getPeerAddress();
            }
        });
        connection.addCloseListener((CloseListener)new ConnectionCloseListener());
        this.outputSink = this.newOutputSink();
    }

    public abstract SpdyVersion getVersion();

    protected abstract SessionOutputSink newOutputSink();

    protected abstract void sendWindowUpdate(int var1);

    protected SpdyStream newStream(HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional) {
        return new SpdyStream(this, spdyRequest, streamId, associatedToStreamId, priority, slot, isUnidirectional);
    }

    boolean canWrite() {
        return this.outputSink.canWrite();
    }

    void notifyCanWrite(WriteHandler writeHandler) {
        this.outputSink.notifyCanWrite(writeHandler);
    }

    public int getLocalStreamWindowSize() {
        return this.localStreamWindowSize;
    }

    public void setLocalStreamWindowSize(int localStreamWindowSize) {
        this.localStreamWindowSize = localStreamWindowSize;
    }

    public int getPeerStreamWindowSize() {
        return this.peerStreamWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPeerStreamWindowSize(int peerStreamWindowSize) {
        Object object = this.sessionLock;
        synchronized (object) {
            int delta = this.peerStreamWindowSize - peerStreamWindowSize;
            this.peerStreamWindowSize = peerStreamWindowSize;
            for (SpdyStream stream : this.streamsMap.values()) {
                try {
                    stream.getOutputSink().onPeerWindowUpdate(delta);
                }
                catch (SpdyStreamException e) {
                    if (LOGGER.isLoggable(LOGGER_LEVEL)) {
                        LOGGER.log(LOGGER_LEVEL, "SpdyStreamException occurred on stream=" + stream + " during stream window update", e);
                    }
                    this.outputSink.writeDownStream(RstStreamFrame.builder().statusCode(e.getRstReason()).streamId(e.getStreamId()).build());
                }
            }
        }
    }

    public int getLocalConnectionWindowSize() {
        return this.localConnectionWindowSize;
    }

    public void setLocalConnectionWindowSize(int localConnectionWindowSize) {
        this.localConnectionWindowSize = localConnectionWindowSize;
    }

    public int getAvailablePeerConnectionWindowSize() {
        return this.outputSink.getAvailablePeerConnectionWindowSize();
    }

    public int getLocalMaxConcurrentStreams() {
        return this.localMaxConcurrentStreams;
    }

    public void setLocalMaxConcurrentStreams(int localMaxConcurrentStreams) {
        this.localMaxConcurrentStreams = localMaxConcurrentStreams;
    }

    public int getPeerMaxConcurrentStreams() {
        return this.peerMaxConcurrentStreams;
    }

    void setPeerMaxConcurrentStreams(int peerMaxConcurrentStreams) {
        this.peerMaxConcurrentStreams = peerMaxConcurrentStreams;
    }

    public int getNextLocalStreamId() {
        this.lastLocalStreamId += 2;
        return this.lastLocalStreamId;
    }

    public StreamBuilder getStreamBuilder() {
        return this.streamBuilder;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MemoryManager getMemoryManager() {
        return this.connection.getMemoryManager();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public SpdyStream getStream(int streamId) {
        return this.streamsMap.get(streamId);
    }

    protected SessionOutputSink getOutputSink() {
        return this.outputSink;
    }

    public void goAway(int statusCode) {
        GoAwayFrame goAwayFrame = this.setGoAwayLocally(statusCode);
        if (goAwayFrame != null) {
            this.outputSink.writeDownStream(goAwayFrame);
        }
    }

    GoAwayFrame setGoAwayLocally(int statusCode) {
        int lastPeerStreamIdLocal = this.close();
        if (lastPeerStreamIdLocal == -1) {
            return null;
        }
        return GoAwayFrame.builder().lastGoodStreamId(lastPeerStreamIdLocal).statusCode(statusCode).build();
    }

    SpdyInflaterOutputStream getInflaterOutputStream() {
        if (this.inflaterOutputStream == null) {
            this.inflaterOutputStream = new SpdyInflaterOutputStream(this.getMemoryManager());
        }
        return this.inflaterOutputStream;
    }

    public int getDeflaterCompressionLevel() {
        return this.deflaterCompressionLevel;
    }

    public void setDeflaterCompressionLevel(int deflaterCompressionLevel) {
        if (this.deflaterOutputStream != null) {
            throw new IllegalStateException("Deflater has been initialized already");
        }
        this.deflaterCompressionLevel = deflaterCompressionLevel;
    }

    ReentrantLock getDeflaterLock() {
        return this.deflaterLock;
    }

    SpdyDeflaterOutputStream getDeflaterOutputStream() {
        if (this.deflaterOutputStream == null) {
            this.deflaterOutputStream = new SpdyDeflaterOutputStream(this.getMemoryManager(), this.deflaterCompressionLevel);
        }
        return this.deflaterOutputStream;
    }

    DataOutputStream getDeflaterDataOutputStream() {
        if (this.deflaterDataOutputStream == null) {
            this.deflaterDataOutputStream = new DataOutputStream(this.getDeflaterOutputStream());
        }
        return this.deflaterDataOutputStream;
    }

    public ReentrantLock getNewClientStreamLock() {
        return this.newClientStreamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpdyStream acceptStream(HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional) throws SpdySessionException {
        SpdyStream spdyStream = this.newStream(spdyRequest, streamId, associatedToStreamId, priority, slot, isUnidirectional);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            if (this.streamsMap.size() >= this.getLocalMaxConcurrentStreams()) {
                throw new SpdySessionException(streamId, 11, 3);
            }
            this.streamsMap.put(streamId, spdyStream);
            this.lastPeerStreamId = streamId;
        }
        return spdyStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyStream openStream(HttpRequestPacket spdyRequest, int streamId, int associatedToStreamId, int priority, int slot, boolean isUnidirectional, boolean fin) throws SpdyStreamException {
        spdyRequest.setExpectContent(!fin);
        SpdyStream spdyStream = this.newStream(spdyRequest, streamId, associatedToStreamId, priority, slot, isUnidirectional);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            if (this.streamsMap.size() >= this.getLocalMaxConcurrentStreams()) {
                throw new SpdyStreamException(streamId, 3);
            }
            if (associatedToStreamId > 0) {
                SpdyStream mainStream = this.getStream(associatedToStreamId);
                if (mainStream == null) {
                    throw new SpdyStreamException(streamId, 3, "The parent stream does not exist");
                }
                mainStream.addAssociatedStream(spdyStream);
            }
            this.streamsMap.put(streamId, spdyStream);
            this.lastLocalStreamId = streamId;
        }
        return spdyStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initCommunication(FilterChainContext context, boolean isUpStream) {
        if (this.downstreamChain == null) {
            SpdySession spdySession = this;
            synchronized (spdySession) {
                if (this.downstreamChain == null) {
                    if (isUpStream) {
                        this.upstreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getEndIdx());
                        this.downstreamChain = (FilterChain)context.getFilterChain().subList(context.getStartIdx(), context.getFilterIdx());
                    } else {
                        this.upstreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getFilterChain().size());
                        this.downstreamChain = (FilterChain)context.getFilterChain().subList(context.getEndIdx() + 1, context.getFilterIdx());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    FilterChain getUpstreamChain() {
        return this.upstreamChain;
    }

    FilterChain getDownstreamChain() {
        return this.downstreamChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close() {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return -1;
            }
            this.closeFlag = CloseType.LOCALLY;
            return this.lastPeerStreamId > 0 ? this.lastPeerStreamId : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGoAwayByPeer(int lastGoodStreamId) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.closeFlag = CloseType.REMOTELY;
        }
    }

    Object getSessionLock() {
        return this.sessionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterStream(SpdyStream spdyStream) {
        boolean isCloseSession;
        this.streamsMap.remove(spdyStream.getStreamId());
        Object object = this.sessionLock;
        synchronized (object) {
            isCloseSession = this.isClosed() && this.streamsMap.isEmpty();
        }
        if (isCloseSession) {
            this.closeSession();
        }
    }

    private void closeSession() {
        this.connection.closeSilently();
        this.outputSink.close();
    }

    private boolean isClosed() {
        return this.closeFlag != null;
    }

    void sendMessageUpstreamWithParseNotify(SpdyStream spdyStream, HttpContent httpContent) {
        FilterChainContext upstreamContext = this.upstreamChain.obtainFilterChainContext(this.connection);
        HttpContext httpContext = httpContent.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.handlerFilter.onHttpContentParsed(httpContent, upstreamContext);
        HttpHeader header = httpContent.getHttpHeader();
        if (httpContent.isLast()) {
            this.handlerFilter.onHttpPacketParsed(header, upstreamContext);
        }
        if (header.isSkipRemainder()) {
            return;
        }
        this.sendMessageUpstream(spdyStream, (HttpPacket)httpContent, upstreamContext);
    }

    void sendMessageUpstream(SpdyStream spdyStream, HttpPacket message) {
        FilterChainContext upstreamContext = this.upstreamChain.obtainFilterChainContext(this.connection);
        HttpContext httpContext = message.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.sendMessageUpstream(spdyStream, message, upstreamContext);
    }

    private void sendMessageUpstream(final SpdyStream spdyStream, HttpPacket message, FilterChainContext upstreamContext) {
        upstreamContext.getInternalContext().setIoEvent(IOEvent.READ);
        upstreamContext.getInternalContext().addLifeCycleListener((IOEventLifeCycleListener)new IOEventLifeCycleListener.Adapter(){

            public void onReregister(Context context) throws IOException {
                spdyStream.inputBuffer.onReadEventComplete();
            }

            public void onComplete(Context context, Object data) throws IOException {
                spdyStream.inputBuffer.onReadEventComplete();
            }
        });
        upstreamContext.setMessage((Object)message);
        upstreamContext.setAddressHolder(this.addressHolder);
        ProcessorExecutor.execute((Context)upstreamContext.getInternalContext());
    }

    private final class ConnectionCloseListener
    implements GenericCloseListener {
        private ConnectionCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            boolean isClosing;
            Object object = SpdySession.this.sessionLock;
            synchronized (object) {
                boolean bl = isClosing = !SpdySession.this.isClosed();
                if (isClosing) {
                    SpdySession.this.closeFlag = type;
                }
            }
            if (isClosing) {
                for (SpdyStream stream : SpdySession.this.streamsMap.values()) {
                    stream.closedRemotely();
                }
            }
        }
    }

    public final class BidirectionalBuilder
    extends HttpHeader.Builder<BidirectionalBuilder> {
        private int priority;
        private int slot;
        private boolean isFin;
        private Method method;
        private String methodString;
        private String uri;
        private String query;
        private String host;

        public BidirectionalBuilder method(Method method) {
            this.method = method;
            this.methodString = null;
            return this;
        }

        public BidirectionalBuilder method(String methodString) {
            this.methodString = methodString;
            this.method = null;
            return this;
        }

        public BidirectionalBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public BidirectionalBuilder query(String query) {
            this.query = query;
            return this;
        }

        public BidirectionalBuilder host(String host) {
            this.host = host;
            return this;
        }

        public BidirectionalBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public BidirectionalBuilder slot(int slot) {
            this.slot = slot;
            return this;
        }

        public BidirectionalBuilder fin(boolean fin) {
            this.isFin = fin;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SpdyStream open() throws SpdyStreamException {
            SpdyRequest request = this.build();
            SpdySession.this.newClientStreamLock.lock();
            try {
                SpdyStream spdyStream = SpdySession.this.openStream(request, SpdySession.this.getNextLocalStreamId(), 0, this.priority, this.slot, false, this.isFin);
                SpdySession.this.connection.write((Object)request);
                SpdyStream spdyStream2 = spdyStream;
                return spdyStream2;
            }
            finally {
                SpdySession.this.newClientStreamLock.unlock();
            }
        }

        public SpdyRequest build() {
            SpdyRequest request = (SpdyRequest)super.build();
            if (this.method != null) {
                request.setMethod(this.method);
            }
            if (this.methodString != null) {
                request.setMethod(this.methodString);
            }
            if (this.uri != null) {
                request.setRequestURI(this.uri);
            }
            if (this.query != null) {
                request.setQueryString(this.query);
            }
            if (this.host != null) {
                request.addHeader(Header.Host, this.host);
            }
            return request;
        }

        protected HttpHeader create() {
            SpdyRequest request = SpdyRequest.create();
            request.setSecure(true);
            return request;
        }
    }

    public final class UnidirectionalBuilder
    extends HttpHeader.Builder<UnidirectionalBuilder> {
        private int associatedToStreamId;
        private int priority;
        private int slot;
        private boolean isFin;
        private String uri;
        private String query;

        public UnidirectionalBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public UnidirectionalBuilder query(String query) {
            this.query = query;
            return this;
        }

        public UnidirectionalBuilder associatedToStreamId(int associatedToStreamId) {
            this.associatedToStreamId = associatedToStreamId;
            return this;
        }

        public UnidirectionalBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public UnidirectionalBuilder slot(int slot) {
            this.slot = slot;
            return this;
        }

        public UnidirectionalBuilder fin(boolean fin) {
            this.isFin = fin;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SpdyStream open() throws SpdyStreamException {
            SpdyRequest request = this.build();
            SpdySession.this.newClientStreamLock.lock();
            try {
                SpdyStream spdyStream = SpdySession.this.openStream(request, SpdySession.this.getNextLocalStreamId(), this.associatedToStreamId, this.priority, this.slot, true, this.isFin);
                SpdySession.this.connection.write((Object)request.getResponse());
                SpdyStream spdyStream2 = spdyStream;
                return spdyStream2;
            }
            finally {
                SpdySession.this.newClientStreamLock.unlock();
            }
        }

        public SpdyRequest build() {
            SpdyRequest request = (SpdyRequest)super.build();
            if (this.uri != null) {
                request.setRequestURI(this.uri);
            }
            if (this.query != null) {
                request.setQueryString(this.query);
            }
            return request;
        }

        protected HttpHeader create() {
            SpdyRequest request = SpdyRequest.create();
            HttpResponsePacket packet = request.getResponse();
            packet.setSecure(true);
            return request;
        }
    }

    public final class StreamBuilder {
        private StreamBuilder() {
        }

        public BidirectionalBuilder bidirectional() {
            return new BidirectionalBuilder();
        }

        public UnidirectionalBuilder unidirectional() {
            return new UnidirectionalBuilder();
        }
    }
}

