/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.websockets.ClientWebSocketMeta;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ServerWebSocketMeta;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketHandler;

public abstract class WebSocketApplication<W extends WebSocket>
implements WebSocketHandler<W> {
    private final Map<W, Boolean> websockets = new ConcurrentHashMap<W, Boolean>();

    public void onAccept(W websocket) throws IOException {
        this.add(websocket);
    }

    @Override
    public void onClose(W websocket) throws IOException {
        this.remove(websocket);
    }

    protected Set<W> getWebSockets() {
        return this.websockets.keySet();
    }

    public boolean add(W websocket) {
        this.websockets.put(websocket, Boolean.TRUE);
        return true;
    }

    public boolean remove(W socket) {
        return this.websockets.remove(socket) != null;
    }

    protected void handshake(ClientWebSocketMeta websocketMeta) throws HandshakeException {
    }

    protected W createWebSocket(Connection connection, ServerWebSocketMeta meta) {
        return null;
    }
}

