/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.frame;

import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.websockets.frame.FixedLengthFrame;
import org.glassfish.grizzly.websockets.frame.ParseResult;
import org.glassfish.grizzly.websockets.frame.StreamFrame;

public abstract class Frame {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    protected int type;
    protected String text;
    private Charset lastCharset;
    protected Buffer buffer;

    public static Frame createTextFrame(String text) {
        return Frame.createFrame(0, text);
    }

    public static Frame createCloseFrame() {
        return new FixedLengthFrame(255, null);
    }

    public static Frame createFrame(int type, String text) {
        return Frame.createFrame(type, text, UTF8_CHARSET);
    }

    public static Frame createFrame(int type, String text, Charset charset) {
        return Frame.createFrame(type, Buffers.wrap(null, (String)text, (Charset)charset));
    }

    public static Frame createFrame(int type, Buffer data) {
        if ((type & 0x80) == 0) {
            return new StreamFrame(type, data);
        }
        return new FixedLengthFrame(type, data);
    }

    protected Frame(int type, Buffer buffer) {
        this.type = type;
        this.buffer = buffer;
    }

    public int getType() {
        return this.type;
    }

    public String getAsText() {
        return this.getAsText(UTF8_CHARSET);
    }

    public String getAsText(Charset charset) {
        if (this.text == null || !charset.equals(this.lastCharset)) {
            this.text = this.buffer.toStringContent(charset);
            this.lastCharset = charset;
        }
        return this.text;
    }

    public Buffer getAsBinary() {
        return this.buffer;
    }

    public String toString() {
        return this.getAsText();
    }

    public abstract boolean isClose();

    public abstract Buffer serialize();

    public abstract ParseResult parse(Buffer var1);
}

