/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.frame;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.NIOTransportBuilder;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.frame.Frame;
import org.glassfish.grizzly.websockets.frame.ParseResult;

class StreamFrame
extends Frame {
    private ParseState parseState = ParseState.TYPE;

    public StreamFrame(int type, Buffer buffer) {
        super(type, buffer);
    }

    @Override
    public final boolean isClose() {
        return false;
    }

    @Override
    public Buffer serialize() {
        MemoryManager mm = NIOTransportBuilder.DEFAULT_MEMORY_MANAGER;
        Buffer startBuffer = mm.allocate(1);
        startBuffer.put(0, (byte)(this.type & 0xFF));
        Buffer resultBuffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)startBuffer, (Buffer)this.buffer);
        Buffer endBuffer = mm.allocate(1);
        endBuffer.put(0, (byte)-1);
        resultBuffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)resultBuffer, (Buffer)endBuffer);
        return resultBuffer;
    }

    @Override
    public ParseResult parse(Buffer buffer) {
        MemoryManager mm = NIOTransportBuilder.DEFAULT_MEMORY_MANAGER;
        switch (this.parseState) {
            case TYPE: {
                if (!buffer.hasRemaining()) {
                    return ParseResult.create(false, null);
                }
                this.type = buffer.get() & 0xFF;
                this.parseState = ParseState.CONTENT;
            }
            case CONTENT: {
                int startPos = buffer.position();
                boolean foundEOF = false;
                while (buffer.hasRemaining()) {
                    if ((buffer.get() & 0xFF) != 255) continue;
                    foundEOF = true;
                    break;
                }
                if (foundEOF) {
                    Buffer remainder = null;
                    if (buffer.hasRemaining()) {
                        remainder = buffer.slice();
                        buffer.limit(buffer.position());
                    }
                    if (buffer.position() - startPos > 1) {
                        Buffers.setPositionLimit((Buffer)buffer, (int)startPos, (int)(buffer.position() - 1));
                        this.buffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)this.buffer, (Buffer)buffer);
                    }
                    buffer = remainder;
                    this.parseState = ParseState.DONE;
                } else {
                    if (startPos != buffer.position()) {
                        buffer.position(startPos);
                        this.buffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)this.buffer, (Buffer)buffer);
                    }
                    return ParseResult.create(false, null);
                }
            }
            case DONE: {
                return ParseResult.create(true, buffer);
            }
        }
        throw new IllegalStateException();
    }

    private static enum ParseState {
        TYPE,
        CONTENT,
        DONE;

    }
}

