/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.websockets.ClientWebSocketMeta;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.SecKey;
import org.glassfish.grizzly.websockets.ServerWebSocketMeta;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketBase;
import org.glassfish.grizzly.websockets.WebSocketClientHandler;
import org.glassfish.grizzly.websockets.WebSocketConnectHandler;
import org.glassfish.grizzly.websockets.WebSocketMeta;

public class WebSocketEngine {
    private final Attribute<WebSocketHolder> webSocketAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("web-socket");
    private static final Logger logger = Grizzly.logger(WebSocketEngine.class);
    private static final WebSocketEngine engine = new WebSocketEngine();
    private final Map<String, WebSocketApplication> applications = new ConcurrentHashMap<String, WebSocketApplication>();

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication lookupApplication(String name) {
        return this.applications.get(name);
    }

    public void registerApplication(String name, WebSocketApplication app) {
        this.applications.put(name, app);
    }

    boolean isWebSocket(Connection connection) {
        return this.webSocketAttr.get((AttributeStorage)connection) != null;
    }

    WebSocket getWebSocket(Connection connection) {
        WebSocketHolder holder = (WebSocketHolder)this.webSocketAttr.get((AttributeStorage)connection);
        return holder != null ? holder.websocket : null;
    }

    WebSocketHolder getWebSocketHolder(Connection connection) {
        return (WebSocketHolder)this.webSocketAttr.get((AttributeStorage)connection);
    }

    WebSocketMeta getWebSocketMeta(Connection connection) {
        WebSocketHolder holder = (WebSocketHolder)this.webSocketAttr.get((AttributeStorage)connection);
        WebSocket ws = holder.websocket;
        Object context = holder.context;
        if (ws != null) {
            return ws.getMeta();
        }
        if (context != null) {
            return (WebSocketMeta)((Object[])context)[0];
        }
        return null;
    }

    WebSocketConnectHandler removeWebSocketConnectHandler(Connection connection) {
        WebSocketHolder holder = (WebSocketHolder)this.webSocketAttr.get((AttributeStorage)connection);
        Object context = holder.context;
        if (context != null) {
            Object value = ((Object[])context)[2];
            ((Object[])context)[2] = null;
            return (WebSocketConnectHandler)value;
        }
        return null;
    }

    void setClientConnectContext(Connection connection, ClientWebSocketMeta meta, WebSocketClientHandler handler, FutureImpl<WebSocket> future) {
        this.webSocketAttr.set((AttributeStorage)connection, (Object)new WebSocketHolder(null, new Object[]{meta, handler, future}));
    }

    WebSocket handleServerHandshake(Connection connection, ClientWebSocketMeta clientMeta) throws HandshakeException {
        WebSocketApplication app = this.lookupApplication(clientMeta.getURI().getPath());
        if (app == null) {
            throw new HandshakeException(404, "Application was not found");
        }
        byte[] serverKey = WebSocketEngine.generateServerKey(clientMeta);
        app.handshake(clientMeta);
        ServerWebSocketMeta serverMeta = new ServerWebSocketMeta(clientMeta.getURI(), clientMeta.getOrigin(), WebSocketEngine.composeServerMetaLocation(clientMeta), clientMeta.getProtocol(), serverKey, clientMeta.isSecure());
        Object websocket = app.createWebSocket(connection, serverMeta);
        if (websocket == null) {
            websocket = new WebSocketBase(connection, serverMeta, app);
        }
        this.webSocketAttr.set((AttributeStorage)connection, (Object)new WebSocketHolder((WebSocket)websocket, null));
        return websocket;
    }

    WebSocket handleClientHandshake(Connection connection, ServerWebSocketMeta serverMeta) throws HandshakeException {
        WebSocketHolder holder = this.getWebSocketHolder(connection);
        Object[] context = (Object[])holder.context;
        ClientWebSocketMeta meta = (ClientWebSocketMeta)context[0];
        WebSocketClientHandler handler = (WebSocketClientHandler)context[1];
        FutureImpl future = (FutureImpl)context[2];
        try {
            byte[] patternServerKey = WebSocketEngine.generateServerKey(meta);
            byte[] serverKey = serverMeta.getKey();
            if (!Arrays.equals(patternServerKey, serverKey)) {
                throw new HandshakeException("Keys do not match");
            }
            Object websocket = handler.createWebSocket(connection, meta);
            if (websocket == null) {
                websocket = new WebSocketBase(connection, meta, handler);
            }
            handler.handshake(websocket, serverMeta);
            holder.websocket = websocket;
            holder.context = null;
            future.result(websocket);
            return websocket;
        }
        catch (HandshakeException e) {
            future.failure((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            future.failure((Throwable)e);
            throw new HandshakeException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static byte[] generateServerKey(ClientWebSocketMeta clientMeta) throws HandshakeException {
        try {
            return SecKey.generateServerKey(clientMeta.getKey1(), clientMeta.getKey2(), clientMeta.getKey3());
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandshakeException(500, "Can not digest using MD5");
        }
    }

    private static String composeServerMetaLocation(ClientWebSocketMeta clientMeta) {
        StringBuilder sb = new StringBuilder(128);
        URI uri = clientMeta.getURI();
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme()).append("://");
        } else {
            sb.append(clientMeta.isSecure() ? "wss://" : "ws://");
        }
        sb.append(clientMeta.getHost());
        sb.append(uri.getPath());
        return sb.toString();
    }

    private static class WebSocketHolder {
        public volatile WebSocket websocket;
        public volatile Object context;

        public WebSocketHolder(WebSocket webSocket, Object context) {
            this.websocket = webSocket;
            this.context = context;
        }
    }
}

