/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.ClientWebSocketMeta;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ServerWebSocketMeta;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketBase;
import org.glassfish.grizzly.websockets.WebSocketClientHandler;
import org.glassfish.grizzly.websockets.WebSocketConnectHandler;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketMeta;
import org.glassfish.grizzly.websockets.frame.Frame;
import org.glassfish.grizzly.websockets.frame.ParseResult;

public class WebSocketFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(WebSocketFilter.class);
    private static final String WEB_SOCKET = "websocket";
    private static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    private static final String SEC_WS_KEY1_HEADER = "Sec-WebSocket-Key1";
    private static final String SEC_WS_KEY2_HEADER = "Sec-WebSocket-Key2";
    private static final String CLIENT_WS_ORIGIN_HEADER = "Origin";
    private static final String SERVER_SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    private static final String SERVER_SEC_WS_LOCATION_HEADER = "Sec-WebSocket-Location";

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        Connection connection = ctx.getConnection();
        if (!this.isWebSocketConnection(connection)) {
            return ctx.getInvokeAction();
        }
        ClientWebSocketMeta meta = (ClientWebSocketMeta)this.getWebSocketMeta(connection);
        HttpContent request = this.composeWSRequest(connection, meta);
        ctx.write((Object)request);
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        if (this.isWebSocketConnection(connection)) {
            WebSocket ws = this.getWebSocket(connection);
            if (ws != null) {
                ws.close();
            } else {
                WebSocketConnectHandler connectHandler = this.removeWebSocketConnectHandler(connection);
                if (connectHandler != null) {
                    connectHandler.failed(new ConnectException());
                }
            }
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpContent content = (HttpContent)ctx.getMessage();
        HttpHeader header = content.getHttpHeader();
        WebSocket ws = this.getWebSocket(connection);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{ws, content.getContent().remaining(), header});
        }
        if (ws == null) {
            if (!(this.isWebSocketConnection(connection) || header.getUpgrade() != null && WEB_SOCKET.equalsIgnoreCase(header.getUpgrade()))) {
                return ctx.getInvokeAction();
            }
            NextAction next = this.handleHandshake(ctx, content);
            if (next != null) {
                return next;
            }
        }
        if (content.getContent().hasRemaining()) {
            Buffer buffer = content.getContent();
            content.recycle();
            if (ws == null) {
                ws = this.getWebSocket(connection);
            }
            WebSocketBase wsBase = (WebSocketBase)ws;
            Frame parsingFrame = wsBase.getParsingFrame();
            while (buffer != null && buffer.hasRemaining()) {
                if (parsingFrame == null) {
                    parsingFrame = Frame.createFrame(buffer.get(buffer.position()) & 0xFF, (Buffer)null);
                    wsBase.setParsingFrame(parsingFrame);
                }
                ParseResult result = parsingFrame.parse(buffer);
                boolean isComplete = result.isComplete();
                buffer = result.getRemainder();
                result.recycle();
                if (!isComplete) break;
                wsBase.setParsingFrame(null);
                if (parsingFrame.isClose()) {
                    ws.close();
                    break;
                }
                ws.getHandler().onMessage(ws, parsingFrame);
                parsingFrame = null;
            }
        }
        return ctx.getStopAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WebSocket websocket = this.getWebSocket(ctx.getConnection());
        if (websocket != null) {
            Frame frame = (Frame)ctx.getMessage();
            Buffer buffer = frame.serialize();
            ctx.setMessage((Object)buffer);
        }
        return ctx.getInvokeAction();
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        if (content.getHttpHeader().isRequest()) {
            int remaining = content.getContent().remaining();
            if (remaining >= 8) {
                this.handleServerHandshake(ctx, content);
            } else if (remaining > 0) {
                return ctx.getStopAction((Appendable)content);
            }
            return ctx.getStopAction();
        }
        HttpResponsePacket response = (HttpResponsePacket)content.getHttpHeader();
        if (response.getStatus() != 101) {
            WebSocketConnectHandler connectHandler = this.removeWebSocketConnectHandler(ctx.getConnection());
            HandshakeException exception = new HandshakeException(response.getStatus(), response.getReasonPhrase());
            if (connectHandler != null) {
                connectHandler.failed(exception);
            }
            throw new IOException(exception);
        }
        int remaining = content.getContent().remaining();
        if (remaining >= 16) {
            this.handleClientHandshake(ctx, content);
        } else if (remaining > 0) {
            return ctx.getStopAction((Appendable)content);
        }
        return null;
    }

    private void handleServerHandshake(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        HttpResponsePacket response;
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        try {
            ClientWebSocketMeta clientMeta;
            try {
                clientMeta = this.composeClientWSMeta(requestContent);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Bad client credentials", e);
                throw new HandshakeException(400, "Bad client credentials");
            }
            catch (URISyntaxException e) {
                throw new HandshakeException(400, "Bad client credentials");
            }
            WebSocket websocket = WebSocketEngine.getEngine().handleServerHandshake(ctx.getConnection(), clientMeta);
            response = this.composeWSResponse(ctx.getConnection(), request, (ServerWebSocketMeta)websocket.getMeta());
            ((WebSocketApplication)websocket.getHandler()).onAccept(websocket);
        }
        catch (HandshakeException e) {
            response = this.composeHandshakeError(request, e);
        }
        ctx.write((Object)response);
    }

    private void handleClientHandshake(FilterChainContext ctx, HttpContent responseContent) throws IOException {
        Connection connection = ctx.getConnection();
        ServerWebSocketMeta serverMeta = this.composeServerWSMeta(responseContent);
        try {
            WebSocket websocket = WebSocketEngine.getEngine().handleClientHandshake(connection, serverMeta);
            ((WebSocketClientHandler)websocket.getHandler()).onConnect(websocket);
        }
        catch (HandshakeException e) {
            throw new IOException(e);
        }
    }

    private WebSocket getWebSocket(Connection connection) {
        return WebSocketEngine.getEngine().getWebSocket(connection);
    }

    private boolean isWebSocketConnection(Connection connection) {
        return WebSocketEngine.getEngine().isWebSocket(connection);
    }

    private WebSocketMeta getWebSocketMeta(Connection connection) {
        return WebSocketEngine.getEngine().getWebSocketMeta(connection);
    }

    private WebSocketConnectHandler removeWebSocketConnectHandler(Connection connection) {
        return WebSocketEngine.getEngine().removeWebSocketConnectHandler(connection);
    }

    private ClientWebSocketMeta composeClientWSMeta(HttpContent requestContent) throws URISyntaxException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        Buffer buffer = requestContent.getContent();
        byte[] key3 = new byte[8];
        buffer.get(key3);
        return new ClientWebSocketMeta(new URI(request.getRequestURI()), request.getHeader(CLIENT_WS_ORIGIN_HEADER), request.getHeader(SEC_WS_PROTOCOL_HEADER), request.getHeader("host"), request.getHeader(SEC_WS_KEY1_HEADER), request.getHeader(SEC_WS_KEY2_HEADER), key3, request.isSecure());
    }

    private ServerWebSocketMeta composeServerWSMeta(HttpContent responseContent) {
        HttpResponsePacket response = (HttpResponsePacket)responseContent.getHttpHeader();
        Buffer buffer = responseContent.getContent();
        byte[] serverKey = new byte[16];
        buffer.get(serverKey);
        return new ServerWebSocketMeta(null, response.getHeader(SERVER_SEC_WS_ORIGIN_HEADER), response.getHeader(SERVER_SEC_WS_LOCATION_HEADER), response.getHeader(SEC_WS_PROTOCOL_HEADER), serverKey, response.isSecure());
    }

    private HttpContent composeWSRequest(Connection connection, ClientWebSocketMeta meta) {
        URI uri = meta.getURI();
        HttpRequestPacket.Builder builder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method("GET").uri(uri.getPath()).protocol("HTTP/1.1")).upgrade("WebSocket")).header("Connection", "Upgrade")).header("Host", uri.getHost())).header(CLIENT_WS_ORIGIN_HEADER, meta.getOrigin());
        if (meta.getProtocol() != null) {
            builder.header(SEC_WS_PROTOCOL_HEADER, meta.getProtocol());
        }
        builder.header(SEC_WS_KEY1_HEADER, meta.getKey1().getSecKey());
        builder.header(SEC_WS_KEY2_HEADER, meta.getKey2().getSecKey());
        HttpRequestPacket httpRequest = builder.build();
        meta.setHandshakeHeader((HttpHeader)httpRequest);
        MemoryManager mm = connection.getTransport().getMemoryManager();
        return HttpContent.builder((HttpHeader)httpRequest).content(Buffers.wrap((MemoryManager)mm, (byte[])meta.getKey3())).build();
    }

    private HttpContent composeWSResponse(Connection connection, HttpRequestPacket request, ServerWebSocketMeta meta) {
        MemoryManager mm = connection.getTransport().getMemoryManager();
        HttpResponsePacket httpResponse = request.getResponse();
        HttpStatus.WEB_SOCKET_PROTOCOL_HANDSHAKE_101.setValues(httpResponse);
        httpResponse.setProtocol(Protocol.HTTP_1_1);
        httpResponse.setUpgrade("WebSocket");
        httpResponse.setHeader("Connection", "Upgrade");
        httpResponse.setHeader(SERVER_SEC_WS_ORIGIN_HEADER, meta.getOrigin());
        httpResponse.setHeader(SERVER_SEC_WS_LOCATION_HEADER, meta.getLocation());
        String protocol = meta.getProtocol();
        if (protocol != null) {
            httpResponse.setHeader(SEC_WS_PROTOCOL_HEADER, protocol);
        }
        meta.setHandshakeHeader((HttpHeader)httpResponse);
        Buffer serverKeyBuffer = Buffers.wrap((MemoryManager)mm, (byte[])meta.getKey());
        return HttpContent.builder((HttpHeader)httpResponse).content(serverKeyBuffer).build();
    }

    private HttpResponsePacket composeHandshakeError(HttpRequestPacket request, HandshakeException e) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(e.getCode());
        response.setReasonPhrase(e.getMessage());
        return response;
    }
}

