/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class BaseWebSocket
implements WebSocket {
    private EnumSet<State> connectedSet = EnumSet.range(State.CONNECTED, State.CLOSING);
    private static final Logger logger = Grizzly.logger(BaseWebSocket.class);
    Connection connection;
    private final Collection<WebSocketListener> listeners = new ConcurrentLinkedQueue<WebSocketListener>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    public BaseWebSocket(WebSocketListener ... listeners) {
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
    }

    public BaseWebSocket(Connection connection, WebSocketListener[] listeners) {
        this(listeners);
        this.connection = connection;
    }

    public Collection<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConnected() {
        return this.connectedSet.contains((Object)this.state.get());
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void close() {
        this.close(-1, null);
    }

    @Override
    public void close(int code) {
        this.close(code, null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.write(new ClosingFrame(code, reason), null);
        }
    }

    private <T> GrizzlyFuture<T> write(DataFrame frame, CompletionHandler<T> completionHandler) {
        try {
            return this.connection.write((Object)frame, completionHandler);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    @Override
    public void onClose(DataFrame frame) {
        if (this.state.get() == State.CONNECTED) {
            try {
                this.write(new ClosingFrame(), (CompletionHandler)new EmptyCompletionHandler<Object>(){

                    public void completed(Object result) {
                        BaseWebSocket.this.onClose();
                    }
                });
            }
            catch (Exception e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        } else {
            this.onClose();
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        byte[] bytes = frame.getBinaryPayload();
        this.send(new DataFrame(FrameType.PONG, bytes), null);
        for (WebSocketListener listener : this.listeners) {
            listener.onPing(bytes);
        }
    }

    private void onClose() {
        this.state.set(State.CLOSED);
        Iterator<WebSocketListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            WebSocketListener listener = it.next();
            it.remove();
            listener.onClose(this);
        }
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public GrizzlyFuture<DataFrame> send(String data) {
        return this.send(new DataFrame(data), null);
    }

    private GrizzlyFuture<DataFrame> send(DataFrame frame, CompletionHandler<DataFrame> completionHandler) {
        if (this.state.get() == State.CONNECTED) {
            return this.write(frame, completionHandler);
        }
        throw new RuntimeException("Socket is already closed.");
    }

    @Override
    public GrizzlyFuture<DataFrame> send(byte[] data) {
        return this.send(new DataFrame(data), null);
    }

    @Override
    public void onConnect() {
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.state.compareAndSet(State.NEW, State.CONNECTED);
    }

    @Override
    public void onMessage(String text) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

