/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.websockets.BaseWebSocket;
import org.glassfish.grizzly.websockets.ClientHandshake;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.glassfish.grizzly.websockets.WebSocketCompletionHandler;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class ClientWebSocket
extends BaseWebSocket {
    private static final Logger logger = Logger.getLogger("websocket");
    private final URI address;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private TCPNIOTransport transport;

    public ClientWebSocket(String uri, WebSocketListener ... listeners) throws URISyntaxException {
        this(new URI(uri), listeners);
    }

    public ClientWebSocket(URI uri, WebSocketListener ... listeners) {
        super(listeners);
        this.address = uri;
        this.add(new WebSocketAdapter(){

            @Override
            public void onClose(WebSocket socket) {
                super.onClose(socket);
                if (ClientWebSocket.this.transport != null) {
                    try {
                        ClientWebSocket.this.transport.stop();
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                }
            }
        });
    }

    @Override
    public void onClose(DataFrame frame) {
        super.onClose(frame);
    }

    public URI getAddress() {
        return this.address;
    }

    public void execute(Runnable runnable) {
        this.executorService.submit(runnable);
    }

    public WebSocket connect() {
        return this.connect(WebSocketEngine.DEFAULT_TIMEOUT);
    }

    public WebSocket connect(long timeout) {
        try {
            final ClientHandshake handshake = new ClientHandshake(this.address, new String[0]);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "connect websocket handshake={0}", handshake);
            }
            SafeFutureImpl future = SafeFutureImpl.create();
            this.transport = TCPNIOTransportBuilder.newInstance().build();
            this.transport.start();
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(conn, ClientWebSocket.this);
                    holder.handshake = handshake;
                    ClientWebSocket.this.connection = conn;
                }
            };
            final CountDownLatch latch = new CountDownLatch(1);
            this.add(new WebSocketAdapter(){

                @Override
                public void onConnect(WebSocket socket) {
                    super.onConnect(socket);
                    latch.countDown();
                }
            });
            connectorHandler.setProcessor(ClientWebSocket.createFilterChain());
            URI uri = handshake.getURI();
            connectorHandler.connect((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort()), (CompletionHandler)new WebSocketCompletionHandler((FutureImpl<Connection>)future));
            this.connection = (Connection)future.get(timeout, TimeUnit.SECONDS);
            latch.await(timeout, TimeUnit.SECONDS);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandshakeException(e.getMessage());
        }
    }

    private static Processor createFilterChain() {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketFilter());
        return clientFilterChainBuilder.build();
    }
}

