/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.utils.Utils;
import org.glassfish.grizzly.websockets.ClientHandshake;
import org.glassfish.grizzly.websockets.ClosingFrame;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ServerHandshake;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public class WebSocketEngine {
    public static final String SEC_WS_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WS_KEY_HEADER = "Sec-WebSocket-Key";
    public static final String SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    public static final String SEC_WS_VERSION = "Sec-WebSocket-Version";
    public static final String WEBSOCKET = "websocket";
    public static final String RESPONSE_CODE_MESSAGE = "Switching Protocols";
    public static final int RESPONSE_CODE_VALUE = 101;
    public static final String UPGRADE = "upgrade";
    public static final String CONNECTION = "connection";
    public static final int WS_VERSION = 6;
    public static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int DEFAULT_TIMEOUT;
    private static final WebSocketEngine engine;
    private static volatile boolean isWebSocketEnabled;
    static final Logger logger;
    public static final String SERVER_KEY_HASH = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int MASK_SIZE = 4;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final Attribute<WebSocketHolder> webSocketAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("web-socket");

    private WebSocketEngine() {
    }

    public static boolean isWebSocketEnabled() {
        return isWebSocketEnabled;
    }

    public static void setWebSocketEnabled(boolean webSocketEnabled) {
        isWebSocketEnabled = webSocketEnabled;
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(HttpRequestPacket request) {
        for (WebSocketApplication application : this.applications) {
            if (!application.upgrade(request)) continue;
            return application;
        }
        return null;
    }

    public boolean upgrade(FilterChainContext ctx, HttpRequestPacket request) {
        try {
            WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request);
            WebSocket socket = null;
            try {
                if (app != null) {
                    Connection connection = ctx.getConnection();
                    socket = app.createSocket(connection, app);
                    WebSocketHolder holder = new WebSocketHolder(true, socket);
                    this.webSocketAttribute.set((AttributeStorage)connection, (Object)holder);
                    ctx.write((Object)new ServerHandshake(request).respond(request));
                    request.getConnection().addCloseListener(new Connection.CloseListener(){

                        public void onClosed(Connection connection) {
                            WebSocket webSocket = WebSocketEngine.this.getWebSocket(connection);
                            webSocket.close();
                            webSocket.onClose(new ClosingFrame(1001, "Close detected on connection"));
                        }
                    });
                    socket.onConnect();
                    return true;
                }
            }
            catch (HandshakeException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (socket != null) {
                    socket.close();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public void register(String name, WebSocketApplication app) {
        this.register(app);
    }

    public void register(WebSocketApplication app) {
        if (!WebSocketEngine.isWebSocketEnabled()) {
            throw new IllegalStateException(LogMessages.SEVERE_GRIZZLY_WS_NOT_ENABLED());
        }
        this.applications.add(app);
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
    }

    public void unregisterAll() {
        this.applications.clear();
    }

    boolean isWebSocket(Connection connection) {
        return this.webSocketAttribute.get((AttributeStorage)connection) != null;
    }

    WebSocket getWebSocket(Connection connection) {
        WebSocketHolder holder = this.getWebSocketHolder(connection);
        return holder == null ? null : holder.webSocket;
    }

    WebSocketHolder getWebSocketHolder(Connection connection) {
        return (WebSocketHolder)this.webSocketAttribute.get((AttributeStorage)connection);
    }

    WebSocketHolder setWebSocketHolder(Connection connection, WebSocket socket) {
        WebSocketHolder holder = new WebSocketHolder(false, socket);
        holder.webSocket = socket;
        this.webSocketAttribute.set((AttributeStorage)connection, (Object)holder);
        return holder;
    }

    static {
        engine = new WebSocketEngine();
        isWebSocketEnabled = true;
        logger = Logger.getLogger(WEBSOCKET);
        DEFAULT_TIMEOUT = Utils.isDebugVM() ? 900 : 30;
    }

    public static class WebSocketHolder {
        public volatile WebSocket webSocket;
        public volatile ClientHandshake handshake;
        public volatile DataFrame frame;
        public volatile boolean unmaskOnRead;
        public volatile Buffer buffer;

        public WebSocketHolder(boolean unmaskOnRead, WebSocket socket) {
            this.unmaskOnRead = unmaskOnRead;
            this.webSocket = socket;
        }
    }
}

