/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.util.logging.Logger;

public abstract class WebSocketHandshake {
    static final Logger logger = Logger.getLogger("websocket");
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private String location;
    private String[] subProtocol;
    private String[] extensions;

    public WebSocketHandshake(boolean isSecure, String path) {
        this.secure = isSecure;
        this.resourcePath = path;
    }

    public WebSocketHandshake(boolean isSecure, String origin, String serverHostName, int portNumber, String resourcePath) {
        this.origin = origin;
        this.serverHostName = serverHostName;
        this.secure = isSecure;
        this.port = portNumber;
        this.resourcePath = resourcePath;
        this.subProtocol = null;
        this.location = this.buildLocation(isSecure);
    }

    String buildLocation(boolean isSecure) {
        StringBuilder builder = new StringBuilder((isSecure ? "wss" : "ws") + "://" + this.serverHostName);
        if (this.port != 80) {
            builder.append(":" + this.port);
        }
        if (this.resourcePath == null || !this.resourcePath.startsWith("/") && !"".equals(this.resourcePath)) {
            builder.append("/");
        }
        builder.append(this.resourcePath);
        return builder.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    public String[] getSubProtocol() {
        return this.subProtocol;
    }

    public void setSubProtocol(String[] subProtocol) {
        this.sanitize(subProtocol);
        this.subProtocol = subProtocol;
    }

    private void sanitize(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i] == null ? null : strings[i].trim();
            }
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.sanitize(extensions);
        this.extensions = extensions;
    }

    protected String join(String[] values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append("; ");
            }
            builder.append(s);
        }
        return null;
    }
}

