/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.websockets.NetworkHandler;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public abstract class BaseNetworkHandler
implements NetworkHandler {
    protected Buffer buffer;

    @Override
    public String readLine(String encoding) throws IOException {
        int position = this.buffer.position();
        try {
            ByteBuffer chunk = ByteBuffer.allocate(this.buffer.remaining());
            this.buffer.get(chunk);
            int eolIdx = 0;
            int index = 0;
            while (eolIdx == 0 && index < chunk.limit()) {
                byte b = chunk.get(index);
                if (b == 10 || b == 13) {
                    byte next;
                    eolIdx = index;
                    if (index + 1 >= chunk.limit() || (next = chunk.get(index + 1)) != 10 && next != 13) continue;
                    ++eolIdx;
                    ++index;
                    continue;
                }
                ++index;
            }
            if (eolIdx != -1) {
                String result = this.buffer.toStringContent(Charset.forName(encoding), position, eolIdx);
                this.buffer.position(eolIdx + 1);
                return result;
            }
        }
        catch (BufferUnderflowException e) {
            this.buffer.position(position);
            throw e;
        }
        return null;
    }

    public List<String> getBytes() {
        return this.getByteList(this.buffer.position(), this.buffer.limit());
    }

    private List<String> getByteList(int start, int end) {
        return WebSocketEngine.toString(this.buffer.toByteBuffer(start, end).array(), start, end);
    }

    public String toString() {
        return String.format("Active: %s", this.getBytes().toString());
    }
}

