/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketServer {
    private static final Logger logger = Grizzly.logger(WebSocketServer.class);
    private static final Object SYNC = new Object();
    private HttpServer httpServer;

    public WebSocketServer(int port) {
        this.httpServer = HttpServer.createSimpleServer((String)".", (int)port);
        this.httpServer.getServerConfiguration().setHttpServerName("WebSocket Server");
        this.httpServer.getServerConfiguration().setName("WebSocket Server");
        for (NetworkListener networkListener : this.httpServer.getListeners()) {
            networkListener.registerAddOn((AddOn)new WebSocketAddOn());
        }
    }

    public static WebSocketServer createSimpleServer(int port) {
        return new WebSocketServer(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = SYNC;
        synchronized (object) {
            this.httpServer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = SYNC;
        synchronized (object) {
            WebSocketEngine.getEngine().unregisterAll();
            this.httpServer.stop();
        }
    }

    public void register(String name, WebSocketApplication application) {
        WebSocketEngine.getEngine().register(name, application);
    }
}

