/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.ParseResult;
import org.glassfish.grizzly.websockets.WebSocket;

public class DataFrame {
    private static final Logger logger = Logger.getLogger("websocket");
    private static final byte FINAL_FRAME = -128;
    public static final int GRIZZLY_MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private String payload;
    private byte[] bytes;
    private byte[] maskBytes;
    private FrameType type;
    private int maskIndex = 0;
    private long lengthCode = -1L;
    private long length = -1L;

    public DataFrame() {
    }

    public DataFrame(FrameType type) {
        this.type = type;
    }

    public DataFrame(String data) {
        this.setPayload(data);
    }

    public DataFrame(byte[] data) {
        this(FrameType.BINARY, data);
    }

    public DataFrame(FrameType type, byte[] bytes) {
        this.bytes = bytes;
        this.type = type;
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.type = FrameType.TEXT;
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBinaryPayload() {
        return this.bytes;
    }

    public byte[] frame() {
        byte[] payloadBytes = this.type.frame(this);
        byte[] lengthBytes = this.convert(payloadBytes.length);
        int packetLength = 1 + lengthBytes.length;
        byte[] packet = new byte[packetLength + payloadBytes.length];
        packet[0] = this.type.setOpcode((byte)-128);
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        System.arraycopy(payloadBytes, 0, packet, packetLength, payloadBytes.length);
        return packet;
    }

    private void applyMask(byte[] bytes) {
        if (this.maskBytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.applyMask(bytes[i]);
            }
        }
    }

    private byte applyMask(byte value) {
        return (byte)(value ^ this.maskBytes[this.maskIndex++ % 4]);
    }

    public ParseResult unframe(boolean unmask, Buffer buffer) {
        try {
            if (unmask && this.maskBytes == null) {
                this.maskBytes = this.get(buffer, 4);
            }
            if (this.type == null) {
                byte opcodes = this.get(buffer);
                boolean fin = (opcodes & 0xFFFFFF80) == -128;
                this.type = FrameType.valueOf(opcodes);
            }
            if (this.lengthCode == -1L) {
                this.lengthCode = this.get(buffer);
            }
            if (this.length == -1L) {
                this.length = this.lengthCode <= 125L ? this.lengthCode : this.convert(this.get(buffer, this.lengthCode == 126L ? 2 : 8));
                if (this.length > Integer.MAX_VALUE) {
                    throw new FramingException(1004, "Frame too large");
                }
            }
            if (this.bytes == null && this.payload == null) {
                this.type.unframe(this, this.get(buffer, (int)this.length));
            }
            return ParseResult.create(true, buffer);
        }
        catch (BufferUnderflowException e) {
            return ParseResult.create(false, buffer);
        }
    }

    private byte get(Buffer buffer) {
        if (!buffer.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        return this.maskBytes == null ? buffer.get() : this.applyMask(buffer.get());
    }

    private byte[] get(Buffer buffer, int needed) {
        byte[] reading = new byte[needed];
        buffer.get(reading);
        this.applyMask(reading);
        return reading;
    }

    public byte[] convert(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = DataFrame.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    public static byte[] toArray(long length) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(length >>> i * 8);
        }
        return b;
    }

    public long convert(byte[] bytes) {
        long value = 0L;
        for (byte aByte : bytes) {
            value <<= 8;
            value ^= (long)aByte & 0xFFL;
        }
        return value;
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "type=" + (Object)((Object)this.type) + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + (this.bytes == null ? "" : Arrays.toString(this.bytes)) + '}';
    }
}

