/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.glassfish.grizzly.websockets.draft06.ClosingFrame;

public abstract class BaseWebSocketFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(BaseWebSocketFilter.class);
    private static final long DEFAULT_WS_IDLE_TIMEOUT_IN_SECONDS = 900L;
    private final long wsTimeoutMS;

    public BaseWebSocketFilter() {
        this(900L);
    }

    public BaseWebSocketFilter(long wsTimeoutInSeconds) {
        this.wsTimeoutMS = wsTimeoutInSeconds <= 0L ? IdleTimeoutFilter.FOREVER : wsTimeoutInSeconds * 1000L;
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        Connection connection = ctx.getConnection();
        if (!BaseWebSocketFilter.webSocketInProgress(connection)) {
            return ctx.getInvokeAction();
        }
        WebSocketHolder.get((Connection)connection).handshake.initiate(ctx);
        ctx.flush(null);
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        WebSocket ws;
        Connection connection = ctx.getConnection();
        if (BaseWebSocketFilter.webSocketInProgress(connection) && (ws = BaseWebSocketFilter.getWebSocket(connection)) != null) {
            ws.close();
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        block10: {
            Connection connection = ctx.getConnection();
            HttpContent message = (HttpContent)ctx.getMessage();
            HttpHeader header = message.getHttpHeader();
            WebSocketHolder holder = WebSocketHolder.get(connection);
            WebSocket ws = BaseWebSocketFilter.getWebSocket(connection);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{ws, message.getContent().remaining(), header});
            }
            if (ws == null || !ws.isConnected()) {
                if (!BaseWebSocketFilter.webSocketInProgress(connection) && !"websocket".equalsIgnoreCase(header.getUpgrade())) {
                    return ctx.getInvokeAction();
                }
                return this.handleHandshake(ctx, message);
            }
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                message.recycle();
                try {
                    while (buffer != null && buffer.hasRemaining()) {
                        DataFrame result;
                        if (holder.buffer != null) {
                            buffer = Buffers.appendBuffers((MemoryManager)ctx.getMemoryManager(), (Buffer)holder.buffer, (Buffer)buffer);
                            holder.buffer = null;
                        }
                        if ((result = holder.handler.unframe(buffer)) == null) {
                            holder.buffer = buffer;
                            break;
                        }
                        result.respond(holder.webSocket);
                    }
                }
                catch (FramingException e) {
                    holder.webSocket.onClose(new ClosingFrame(e.getClosingCode(), e.getMessage()));
                }
                catch (Exception wse) {
                    if (!holder.application.onError(holder.webSocket, wse)) break block10;
                    holder.webSocket.onClose(new ClosingFrame(1011, wse.getMessage()));
                }
            }
        }
        return ctx.getStopAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WebSocket websocket = BaseWebSocketFilter.getWebSocket(ctx.getConnection());
        Object msg = ctx.getMessage();
        if (websocket != null && DataFrame.isDataFrame(msg)) {
            DataFrame frame = (DataFrame)msg;
            WebSocketHolder holder = WebSocketHolder.get(ctx.getConnection());
            Buffer wrap = Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])holder.handler.frame(frame));
            ctx.setMessage((Object)wrap);
            ctx.flush(null);
        }
        return ctx.getInvokeAction();
    }

    protected abstract NextAction handleHandshake(FilterChainContext var1, HttpContent var2) throws IOException;

    private static WebSocket getWebSocket(Connection connection) {
        return WebSocketHolder.getWebSocket(connection);
    }

    private static boolean webSocketInProgress(Connection connection) {
        return WebSocketHolder.isWebSocketInProgress(connection);
    }

    protected static HttpResponsePacket composeHandshakeError(HttpRequestPacket request, HandshakeException e) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(e.getCode());
        response.setReasonPhrase(e.getMessage());
        return response;
    }

    protected void setIdleTimeout(FilterChainContext ctx) {
        FilterChain filterChain = ctx.getFilterChain();
        if (filterChain.indexOfType(IdleTimeoutFilter.class) >= 0) {
            IdleTimeoutFilter.setCustomTimeout((Connection)ctx.getConnection(), (long)this.wsTimeoutMS, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }
}

