/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.BaseWebSocketFilter;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketFilter
extends BaseWebSocketFilter {
    public WebSocketFilter() {
    }

    public WebSocketFilter(long wsTimeoutInSeconds) {
        super(wsTimeoutInSeconds);
    }

    @Override
    protected NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return this.handleServerHandshake(ctx, content);
    }

    private NextAction handleServerHandshake(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        try {
            if (this.doServerUpgrade(ctx, requestContent)) {
                return ctx.getInvokeAction();
            }
            this.setIdleTimeout(ctx);
        }
        catch (HandshakeException e) {
            ctx.write((Object)WebSocketFilter.composeHandshakeError(request, e));
        }
        ctx.flush(null);
        requestContent.recycle();
        return ctx.getStopAction();
    }

    protected boolean doServerUpgrade(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        return !WebSocketEngine.getEngine().upgrade(ctx, requestContent);
    }
}

