/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.grizzly.websockets.glassfish.GlassfishSupport;

public class DefaultWebSocket
extends SimpleWebSocket {
    private static final Logger LOGGER = Grizzly.logger(DefaultWebSocket.class);
    protected final HttpServletRequest servletRequest;

    public DefaultWebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(protocolHandler, listeners);
        FilterChainContext ctx = protocolHandler.getFilterChainContext();
        if (ctx != null) {
            WSRequestImpl grizzlyRequest = new WSRequestImpl();
            Response grizzlyResponse = grizzlyRequest.getResponse();
            grizzlyRequest.initialize(request, ctx, null);
            grizzlyResponse.initialize((Request)grizzlyRequest, request.getResponse(), ctx, null, null);
            try {
                grizzlyRequest.parseSessionId();
                WSServletRequestImpl grizzlyServletRequest = new WSServletRequestImpl();
                HttpServletResponseImpl grizzlyServletResponse = HttpServletResponseImpl.create();
                Mapper mapper = protocolHandler.getMapper();
                grizzlyServletRequest.initialize(grizzlyRequest, grizzlyServletResponse, mapper);
                grizzlyServletResponse.initialize(grizzlyResponse, (HttpServletRequestImpl)grizzlyServletRequest);
                this.servletRequest = grizzlyServletRequest;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected exception", e);
            }
        } else {
            this.servletRequest = null;
        }
    }

    public HttpServletRequest getUpgradeRequest() {
        return this.servletRequest;
    }

    private static class WSServletRequestImpl
    extends HttpServletRequestImpl {
        private GlassfishSupport glassfishSupport;
        private String pathInfo;
        private String servletPath;
        private String contextPath;
        private boolean isUserPrincipalUpdated;

        private WSServletRequestImpl() {
        }

        public void initialize(Request request, HttpServletResponseImpl servletResponse, Mapper mapper) throws IOException {
            if (mapper != null) {
                MappingData mappingData = this.updatePaths(request, mapper);
                this.glassfishSupport = new GlassfishSupport(mappingData.context, mappingData.wrapper, (HttpServletRequest)this);
            } else {
                this.glassfishSupport = new GlassfishSupport();
                this.contextPath = request.getContextPath();
            }
            super.initialize(request, servletResponse, new WebappContext("web-socket-ctx", this.contextPath));
        }

        protected void initSession() {
            if (!this.glassfishSupport.isValid()) {
                super.initSession();
            }
        }

        public HttpSession getSession(boolean create) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.getSession(create);
            }
            return super.getSession(create);
        }

        public boolean isUserInRole(String role) {
            if (this.glassfishSupport.isValid()) {
                return this.glassfishSupport.isUserInRole(role);
            }
            return super.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            this.checkGlassfishAuth();
            return super.getUserPrincipal();
        }

        public String getRemoteUser() {
            this.checkGlassfishAuth();
            return super.getRemoteUser();
        }

        public String getAuthType() {
            this.checkGlassfishAuth();
            return super.getAuthType();
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        private MappingData updatePaths(Request request, Mapper mapper) {
            try {
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                DataChunk decodedURI = uriRef.getDecodedRequestURIBC(true);
                MappingData mappingData = request.obtainMappingData();
                mapper.mapUriWithSemicolon(request.getRequest().serverName(), decodedURI, mappingData, 0);
                this.pathInfo = mappingData.pathInfo.toString();
                this.servletPath = mappingData.wrapperPath.toString();
                this.contextPath = mappingData.contextPath.toString();
                return mappingData;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to map request", e);
                }
                this.pathInfo = null;
                this.servletPath = null;
                this.contextPath = null;
                return null;
            }
        }

        private void checkGlassfishAuth() {
            if (this.glassfishSupport.isValid() && !this.isUserPrincipalUpdated) {
                this.isUserPrincipalUpdated = true;
                this.glassfishSupport.updateUserPrincipal(this.request);
            }
        }
    }

    private static class WSResponseImpl
    extends Response {
    }

    private class WSRequestImpl
    extends Request {
        public WSRequestImpl() {
            super((Response)new WSResponseImpl());
        }

        protected void parseSessionId() {
            super.parseSessionId();
            Cookie[] parsedCookies = this.getCookies();
            if (parsedCookies != null) {
                for (Cookie c : parsedCookies) {
                    if (!"JSESSIONID".equals(c.getName())) continue;
                    this.setRequestedSessionId(c.getValue());
                    this.setRequestedSessionCookie(true);
                    break;
                }
            }
        }
    }
}

