/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.osgi.httpservice.util;

import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Logger {
    private final ServiceTracker logTracker;

    public Logger(ServiceTracker logTracker) {
        this.logTracker = logTracker;
    }

    private void log(int logLevel, String msg) {
        LogService log = (LogService)this.logTracker.getService();
        if (log == null) {
            if (logLevel < 2) {
                System.out.println(msg);
            }
        } else {
            log.log(logLevel, msg);
        }
    }

    private void log(int logLevel, String msg, Throwable e) {
        LogService log = (LogService)this.logTracker.getService();
        if (log == null) {
            System.out.println(msg);
            e.printStackTrace(System.out);
        } else {
            log.log(logLevel, msg, e);
        }
    }

    public void info(String msg) {
        this.log(3, msg);
    }

    public void debug(String msg) {
        this.log(4, msg);
    }

    public void warn(String msg) {
        this.log(2, msg);
    }

    public void warn(String msg, Throwable e) {
        this.log(2, msg, e);
    }

    public void error(String msg, Throwable e) {
        this.log(1, msg, e);
    }
}

