/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.connectionpool;

import java.io.IOException;
import java.net.SocketAddress;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.EchoFilter;
import org.glassfish.grizzly.utils.StringFilter;

public class EchoServer {
    private final SocketAddress endpointAddress;
    private Transport transport;
    private boolean isRunning;

    public EchoServer(SocketAddress endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public SocketAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public void start() throws IOException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        FilterChain filterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)new StringFilter(Charsets.UTF8_CHARSET)).add((Filter)new EchoFilter()).build();
        TCPNIOTransport tcpTransport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor((Processor)filterChain)).build();
        this.transport = tcpTransport;
        tcpTransport.bind(this.endpointAddress);
        tcpTransport.start();
    }

    public void stop() throws IOException {
        if (!this.isRunning) {
            return;
        }
        Transport localTransport = this.transport;
        this.transport = null;
        localTransport.shutdownNow();
    }
}

