/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.comet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.comet.CometContext;
import org.glassfish.grizzly.comet.CometEngine;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.samples.comet.CounterHandler;

public class LongPollingServlet
extends HttpServlet {
    final AtomicInteger counter = new AtomicInteger();
    private static final long serialVersionUID = 1L;
    private String contextPath = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.contextPath = context.getContextPath() + "/long_polling";
        CometEngine engine = CometEngine.getEngine();
        CometContext cometContext = engine.register(this.contextPath);
        cometContext.setExpirationDelay(150000L);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CometEngine engine = CometEngine.getEngine();
        CometContext context = engine.getCometContext(this.contextPath);
        context.addCometHandler((CometHandler)new CounterHandler(res, this.counter));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.counter.incrementAndGet();
        CometContext context = CometEngine.getEngine().getCometContext(this.contextPath);
        context.notify(null);
        PrintWriter writer = res.getWriter();
        writer.write("success");
        writer.flush();
    }
}

