/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.http.download;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.http.download.ClientDownloadFilter;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

public class Client {
    private static final Logger logger = Grizzly.logger(Client.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, URISyntaxException {
        if (args.length < 1) {
            System.out.println("To download the resource, please run: Client <url>");
            System.exit(0);
        }
        String url = args[0];
        URI uri = new URI(url);
        String host = uri.getHost();
        int port = uri.getPort() > 0 ? uri.getPort() : 80;
        DelayedExecutor timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor();
        timeoutExecutor.start();
        SafeFutureImpl completeFuture = SafeFutureImpl.create();
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new IdleTimeoutFilter(timeoutExecutor, 10L, TimeUnit.SECONDS));
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new ClientDownloadFilter(uri, (FutureImpl<String>)completeFuture));
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)clientFilterChainBuilder.build());
        try {
            transport.start();
            Connection connection = null;
            GrizzlyFuture connectFuture = transport.connect(host, port);
            try {
                connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
                String filename = (String)completeFuture.get();
                logger.log(Level.INFO, "File " + filename + " was successfully downloaded");
            }
            catch (Exception e) {
                if (connection == null) {
                    logger.log(Level.WARNING, "Can not connect to the target resource");
                } else {
                    logger.log(Level.WARNING, "Error downloading the resource");
                }
            }
            finally {
                if (connection != null) {
                    connection.closeSilently();
                }
            }
        }
        finally {
            logger.info("Stopping transport...");
            transport.shutdownNow();
            timeoutExecutor.stop();
            timeoutExecutor.destroy();
            logger.info("Stopped transport...");
        }
    }
}

