/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.http.download;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.impl.FutureImpl;

public class ClientDownloadFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(ClientDownloadFilter.class);
    private final URI uri;
    private final String fileName;
    private final FutureImpl<String> completeFuture;
    private volatile FileChannel output;
    private volatile int bytesDownloaded;
    private final String resourcePath;

    public ClientDownloadFilter(URI uri, FutureImpl<String> completeFuture) {
        this.uri = uri;
        this.resourcePath = uri.getPath().trim().length() > 0 ? uri.getPath().trim() : "/";
        int lastSlashIdx = this.resourcePath.lastIndexOf(47);
        this.fileName = lastSlashIdx != -1 && lastSlashIdx < this.resourcePath.length() - 1 ? this.resourcePath.substring(lastSlashIdx + 1) : "download#" + System.currentTimeMillis() + ".txt";
        this.completeFuture = completeFuture;
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        HttpRequestPacket httpRequest = ((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method("GET").uri(this.resourcePath).protocol(Protocol.HTTP_1_1)).header("Host", this.uri.getHost())).build();
        logger.log(Level.INFO, "Connected... Sending the request: {0}", httpRequest);
        ctx.write((Object)httpRequest);
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            HttpContent httpContent = (HttpContent)ctx.getMessage();
            logger.log(Level.FINE, "Got HTTP response chunk");
            if (this.output == null) {
                logger.log(Level.INFO, "HTTP response: {0}", httpContent.getHttpHeader());
                logger.log(Level.FINE, "Create a file: {0}", this.fileName);
                FileOutputStream fos = new FileOutputStream(this.fileName);
                this.output = fos.getChannel();
            }
            Buffer buffer = httpContent.getContent();
            logger.log(Level.FINE, "HTTP content size: {0}", buffer.remaining());
            if (buffer.remaining() > 0) {
                this.bytesDownloaded += buffer.remaining();
                ByteBuffer byteBuffer = buffer.toByteBuffer();
                do {
                    this.output.write(byteBuffer);
                } while (byteBuffer.hasRemaining());
                buffer.dispose();
            }
            if (httpContent.isLast()) {
                logger.log(Level.FINE, "Downloaded done: {0} bytes", this.bytesDownloaded);
                this.completeFuture.result((Object)this.fileName);
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
        }
        return ctx.getStopAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.close();
        return ctx.getStopAction();
    }

    private void close() throws IOException {
        FileChannel localOutput = this.output;
        if (localOutput != null) {
            localOutput.close();
        }
        if (!this.completeFuture.isDone()) {
            this.completeFuture.failure((Throwable)new IOException("Connection was closed"));
        }
    }
}

