/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.http.download;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.samples.http.download.WebServerFilter;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.slf4j.Logger;

public class Server {
    private static final Logger LOGGER = Grizzly.logger(Server.class);
    public static final String HOST = "localhost";
    public static final int PORT = 7777;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        DelayedExecutor timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor();
        timeoutExecutor.start();
        FilterChainBuilder serverFilterChainBuilder = FilterChainBuilder.stateless();
        serverFilterChainBuilder.add((Filter)new TransportFilter());
        serverFilterChainBuilder.add((Filter)new IdleTimeoutFilter(timeoutExecutor, 10L, TimeUnit.SECONDS));
        serverFilterChainBuilder.add((Filter)new HttpServerFilter());
        serverFilterChainBuilder.add((Filter)new WebServerFilter("."));
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)serverFilterChainBuilder.build());
        try {
            transport.bind(HOST, 7777);
            transport.start();
            LOGGER.info("Press any key to stop the server...");
            System.in.read();
        }
        finally {
            LOGGER.info("Stopping transport...");
            transport.shutdownNow();
            timeoutExecutor.stop();
            timeoutExecutor.destroy();
            LOGGER.info("Stopped transport...");
        }
    }
}

