/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.httpserver.nonblockinghandler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.memory.MemoryManager;

public class DownloadHttpHandlerSample {
    private static final Logger LOGGER = Grizzly.logger(DownloadHttpHandlerSample.class);
    private static final int CHUNK_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String downloadFolderName;
        File downloadFolder;
        if (args.length == 0) {
            System.out.println("Usage: DownloadHttpHandlerSample <download-folder>");
            System.exit(1);
        }
        if (!(downloadFolder = new File(downloadFolderName = args[0])).isDirectory()) {
            System.out.println("The argument " + downloadFolderName + " is not a folder!");
            System.exit(1);
        }
        NetworkListener networkListener = new NetworkListener("downloader", "0.0.0.0", 8080);
        networkListener.setMaxPendingBytes(32768);
        HttpServer server = new HttpServer();
        server.addListener(networkListener);
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new NonBlockingDownloadHandler(downloadFolder), new String[]{"/"});
        try {
            server.start();
            LOGGER.info("Press enter to stop the server...");
            System.in.read();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
        }
        finally {
            server.shutdownNow();
        }
    }

    private static class NonBlockingDownloadHandler
    extends HttpHandler {
        private final File parentFolder;

        public NonBlockingDownloadHandler(File parentFolder) {
            this.parentFolder = parentFolder;
        }

        public void service(final Request request, final Response response) throws Exception {
            response.setBufferSize(0);
            final NIOOutputStream output = response.getNIOOutputStream();
            String path = request.getDecodedRequestURI();
            final File file = new File(this.parentFolder, path);
            if (!file.isFile()) {
                response.setStatus(HttpStatus.NOT_FOUND_404);
                return;
            }
            final FileChannel fileChannel = new FileInputStream(file).getChannel();
            String contentType = MimeType.getByFilename((String)path);
            response.setContentType(contentType != null ? contentType : "binary/octet-stream");
            response.suspend();
            output.notifyCanWrite(new WriteHandler(){
                private long size;
                {
                    this.size = file.length();
                }

                public void onWritePossible() throws Exception {
                    LOGGER.log(Level.FINE, "[onWritePossible]");
                    boolean isWriteMore = this.sendChunk();
                    if (isWriteMore) {
                        output.notifyCanWrite((WriteHandler)this);
                    }
                }

                public void onError(Throwable t) {
                    LOGGER.log(Level.WARNING, "[onError] ", t);
                    response.setStatus(500, t.getMessage());
                    this.complete(true);
                }

                private boolean sendChunk() throws IOException {
                    MemoryManager mm = request.getContext().getMemoryManager();
                    Buffer buffer = mm.allocate(8192);
                    buffer.allowBufferDispose(true);
                    int justReadBytes = fileChannel.read(buffer.toByteBuffer());
                    if (justReadBytes <= 0) {
                        this.complete(false);
                        return false;
                    }
                    buffer.position(justReadBytes);
                    buffer.trim();
                    output.write(buffer);
                    this.size -= (long)justReadBytes;
                    if (this.size <= 0L) {
                        this.complete(false);
                        return false;
                    }
                    return true;
                }

                private void complete(boolean isError) {
                    block7: {
                        block6: {
                            try {
                                fileChannel.close();
                            }
                            catch (IOException e) {
                                if (isError) break block6;
                                response.setStatus(500, e.getMessage());
                            }
                        }
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            if (isError) break block7;
                            response.setStatus(500, e.getMessage());
                        }
                    }
                    if (response.isSuspended()) {
                        response.resume();
                    } else {
                        response.finish();
                    }
                }
            });
        }
    }
}

