/*
 * Copyright (c) 2014, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.grizzly.samples.httpserver.secure;

import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

/**
 * Simple {@link HttpHandler} implementation.
 */
public class SimpleHttpHandler extends HttpHandler {

    @Override
    public void service(final Request request, final Response response) throws Exception {
        response.setContentType("text/plain");
        response.getWriter().write("Hello world!");
    }

}
