/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.sni.httpserver;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.samples.sni.httpserver.FooBarSNIResolver;
import org.glassfish.grizzly.samples.sni.httpserver.SNIAddOn;
import org.glassfish.grizzly.samples.sni.httpserver.SimpleHttpHandler;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

public class Server {
    private static final Logger LOGGER = Grizzly.logger(Server.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HttpServer server = new HttpServer();
        ServerConfiguration config = server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new SimpleHttpHandler(), new String[]{"/"});
        NetworkListener networkListener = new NetworkListener("secured-listener", "0.0.0.0", 8080);
        networkListener.setSecure(true);
        FooBarSNIResolver resolver = new FooBarSNIResolver(Server.createSslConfiguration("foo.jks"), Server.createSslConfiguration("bar.jks"));
        networkListener.registerAddOn((AddOn)new SNIAddOn(resolver));
        server.addListener(networkListener);
        try {
            server.start();
            System.out.println("The SNI-aware server is running on port 8080\nPress enter to stop...");
            System.in.read();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
        }
        finally {
            server.shutdownNow();
        }
    }

    private static SSLEngineConfigurator createSslConfiguration(String keyStoreName) {
        SSLContextConfigurator sslContextConfig = new SSLContextConfigurator();
        ClassLoader cl = Server.class.getClassLoader();
        URL keystoreUrl = cl.getResource(keyStoreName);
        if (keystoreUrl != null) {
            sslContextConfig.setKeyStoreFile(keystoreUrl.getFile());
            sslContextConfig.setKeyStorePass("changeit");
        }
        return new SSLEngineConfigurator(sslContextConfig.createSSLContext(), false, false, false);
    }
}

