/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.samples.sni.httpserver;

import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLBaseFilter;

public class SNIAddOn
implements AddOn {
    private final SNIFilter sniFilter;
    private final SNIServerConfigResolver serverConfigResolver;

    public SNIAddOn(SNIServerConfigResolver serverConfigResolver) {
        if (serverConfigResolver == null) {
            throw new IllegalArgumentException("serverConfigResolver can't be null");
        }
        this.serverConfigResolver = serverConfigResolver;
        this.sniFilter = null;
    }

    public SNIAddOn(SNIFilter sniFilter) {
        if (sniFilter == null) {
            throw new IllegalArgumentException("sniFilter can't be null");
        }
        this.sniFilter = sniFilter;
        this.serverConfigResolver = null;
    }

    public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
        int sslFilterIdx = builder.indexOfType(SSLBaseFilter.class);
        if (sslFilterIdx != -1) {
            SSLBaseFilter sslFilter = (SSLBaseFilter)builder.get(sslFilterIdx);
            SNIFilter sniFilterLocal = this.sniFilter;
            if (sniFilterLocal == null) {
                sniFilterLocal = new SNIFilter(sslFilter.getServerSSLEngineConfigurator(), null, sslFilter.isRenegotiateOnClientAuthWant());
                sniFilterLocal.setServerSSLConfigResolver(this.serverConfigResolver);
            }
            builder.set(sslFilterIdx, (Filter)sniFilterLocal);
        }
    }
}

