/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.spi;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.ha.store.spi.BackingStoreException;
import org.glassfish.ha.store.spi.BackingStoreFactory;
import org.glassfish.ha.store.spi.DuplicateFactoryRegistrationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BackingStoreRegistry {
    private static BackingStoreRegistry _instance = new BackingStoreRegistry();
    private Map<String, BackingStoreInfo> type2BackingStoreInfo = new ConcurrentHashMap<String, BackingStoreInfo>();

    private BackingStoreRegistry() {
    }

    public static BackingStoreRegistry getInstance() {
        return _instance;
    }

    public synchronized void register(String type, String factoryClassName, Properties props) throws DuplicateFactoryRegistrationException {
        if (this.type2BackingStoreInfo.get(type) != null) {
            throw new DuplicateFactoryRegistrationException("Duplicate factory class (" + factoryClassName + ") for type: " + type);
        }
        this.type2BackingStoreInfo.put(type, new BackingStoreInfo(factoryClassName, props));
    }

    public boolean remove(String type) {
        return this.type2BackingStoreInfo.remove(type) != null;
    }

    public String getFactoryClassName(String type) {
        BackingStoreInfo info = this.type2BackingStoreInfo.get(type);
        return info == null ? null : info.className;
    }

    public Properties getFactoryClassEnv(String type) {
        BackingStoreInfo info = this.type2BackingStoreInfo.get(type);
        return info == null ? null : info.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingStoreFactory getFactoryInstance(String type) throws BackingStoreException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BackingStoreFactory factory = null;
        BackingStoreInfo info = this.type2BackingStoreInfo.get(type);
        if (info != null) {
            if (info.factory == null) {
                BackingStoreInfo backingStoreInfo = info;
                synchronized (backingStoreInfo) {
                    Class<?> clazz = Class.forName(info.className);
                    info.factory = (BackingStoreFactory)clazz.newInstance();
                }
            }
            factory = info.factory;
        }
        return factory;
    }

    public Collection<String> getRegisteredTypes() {
        return this.type2BackingStoreInfo.keySet();
    }

    private static class BackingStoreInfo {
        String className;
        Properties props;
        volatile BackingStoreFactory factory;

        BackingStoreInfo(String className, Properties props) {
            this.className = className;
            this.props = props;
        }
    }
}

