/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.store.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.criteria.Criteria;
import org.glassfish.ha.store.impl.NoOpBackingStoreFactory;
import org.glassfish.ha.store.spi.ObjectInputOutputStreamFactory;
import org.glassfish.ha.store.spi.ObjectInputOutputStreamFactoryRegistry;
import org.glassfish.ha.store.spi.ObjectInputStreamWithLoader;
import org.glassfish.ha.store.spi.StoreEntryEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackingStore<K extends Serializable, V extends Serializable> {
    BackingStoreConfiguration<K, V> conf;

    protected void initialize(BackingStoreConfiguration<K, V> conf) throws BackingStoreException {
        this.conf = conf;
    }

    protected BackingStoreConfiguration<K, V> getBackingStoreConfiguration() {
        return this.conf;
    }

    public abstract V load(Object var1, String var2) throws BackingStoreException;

    public abstract String save(K var1, V var2, boolean var3) throws BackingStoreException;

    public abstract void remove(K var1) throws BackingStoreException;

    public abstract void updateTimestamp(K var1, long var2) throws BackingStoreException;

    public String updateTimestamp(K key, Long version, Long accessTime, Long maxIdleTime) throws BackingStoreException {
        return "";
    }

    public abstract int removeExpired(long var1) throws BackingStoreException;

    public int removeExpired() throws BackingStoreException {
        return 0;
    }

    public void removeByCriteria(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval) throws BackingStoreException {
    }

    public abstract int size() throws BackingStoreException;

    public abstract void destroy() throws BackingStoreException;

    public Collection findByCriteria(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval) {
        return Collections.EMPTY_LIST;
    }

    public void close() throws BackingStoreException {
    }

    public BackingStoreFactory getBackingStoreFactory() {
        return new NoOpBackingStoreFactory();
    }

    public Collection synchronizeKeys(Criteria<V> criteria, StoreEntryEvaluator<K, V> eval, boolean eagerFetch) {
        return Collections.EMPTY_LIST;
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        ObjectInputOutputStreamFactory oosf = ObjectInputOutputStreamFactoryRegistry.getObjectInputOutputStreamFactory();
        return oosf == null ? new ObjectOutputStream(os) : oosf.createObjectOutputStream(os);
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithLoader(is, this.conf.getValueClazz().getClassLoader());
    }
}

