/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.ContractProvided;

public class ContractFinder {
    private final Set<InterfaceDeclaration> checkedInterfaces = new HashSet<InterfaceDeclaration>();
    private final Set<TypeDeclaration> result = new HashSet<TypeDeclaration>();

    public static Set<TypeDeclaration> find(TypeDeclaration d) {
        return new ContractFinder().check((TypeDeclaration)d).result;
    }

    private ContractFinder() {
    }

    private ContractFinder check(TypeDeclaration d) {
        this.checkContractProvided(d);
        while (true) {
            this.checkSuperInterfaces(d);
            if (!(d instanceof ClassDeclaration)) break;
            ClassDeclaration cd = (ClassDeclaration)d;
            this.checkContract((TypeDeclaration)cd);
            ClassType sc = cd.getSuperclass();
            if (sc == null) break;
            d = sc.getDeclaration();
        }
        return this;
    }

    private void checkContractProvided(TypeDeclaration impl) {
        ContractProvided provided = (ContractProvided)impl.getAnnotation(ContractProvided.class);
        if (provided != null) {
            try {
                provided.value();
            }
            catch (MirroredTypeException e) {
                this.result.add(((DeclaredType)e.getTypeMirror()).getDeclaration());
            }
        }
    }

    private void checkContract(TypeDeclaration type) {
        if (type.getAnnotation(Contract.class) != null) {
            this.result.add(type);
        }
    }

    private void checkSuperInterfaces(TypeDeclaration d) {
        for (InterfaceType intf : d.getSuperinterfaces()) {
            InterfaceDeclaration i = intf.getDeclaration();
            if (!this.checkedInterfaces.add(i)) continue;
            this.checkContract((TypeDeclaration)i);
            this.checkSuperInterfaces((TypeDeclaration)i);
        }
    }
}

