/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Hk2ThreadContext;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.InjectionPointImpl;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.ContractLocatorImpl;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.SimpleServiceLocator;
import org.jvnet.tiger_types.Types;

public class InjectInjectionResolver
extends InjectionResolver<Inject> {
    final Habitat habitat;

    public InjectInjectionResolver(Habitat habitat) {
        super(Inject.class);
        this.habitat = habitat;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Inject annotation) {
        return annotation.optional();
    }

    @Override
    public <V> V getValue(final Object component, final Inhabitant<?> onBehalfOf, final AnnotatedElement target, final Type genericType, final Class<V> type) throws ComponentException {
        final Inject inject = target.getAnnotation(Inject.class);
        Callable callable = new Callable<V>(){

            @Override
            public V call() throws ComponentException {
                Object result = null;
                if (type.isArray()) {
                    result = InjectInjectionResolver.this.getArrayInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type);
                } else if (Types.isSubClassOf(type, Factory.class)) {
                    result = InjectInjectionResolver.this.getHolderInjectValue(InjectInjectionResolver.this.habitat, component, onBehalfOf, target, genericType, type, inject);
                } else if (genericType instanceof TypeVariable) {
                    TypeVariable<Class<?>>[] typeVariables = component.getClass().getTypeParameters();
                    for (int i = 0; i < typeVariables.length; ++i) {
                        if (!typeVariables[i].getName().equals(((TypeVariable)genericType).getName())) continue;
                        String parameterizedType = onBehalfOf.metadata().get("paramType").get(i);
                        try {
                            Class<?> clazz = component.getClass().getClassLoader().loadClass(parameterizedType);
                            ContractLocatorImpl contractLocator = new ContractLocatorImpl((SimpleServiceLocator)InjectInjectionResolver.this.habitat, clazz, InjectInjectionResolver.this.habitat.isContract(clazz));
                            InjectInjectionResolver.this.populateContractLocator(contractLocator, target, inject);
                            result = contractLocator.get();
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            Logger.getAnonymousLogger().warning("Cannot load class " + parameterizedType);
                            return null;
                        }
                    }
                } else {
                    ContractLocatorImpl contractLocator = new ContractLocatorImpl((SimpleServiceLocator)InjectInjectionResolver.this.habitat, genericType, InjectInjectionResolver.this.habitat.isContract(genericType));
                    InjectInjectionResolver.this.populateContractLocator(contractLocator, target, inject);
                    result = contractLocator.get();
                }
                return result == null ? null : InjectInjectionResolver.this.validate(component, onBehalfOf, result);
            }
        };
        try {
            if (this.habitat.isContextualFactoriesPresent()) {
                InjectionPointImpl ip = new InjectionPointImpl(component, target, type, inject, onBehalfOf);
                return Hk2ThreadContext.captureIPandRun(ip, callable);
            }
            return callable.call();
        }
        catch (Exception e) {
            if (e instanceof ComponentException) {
                throw (ComponentException)((Object)ComponentException.class.cast(e));
            }
            throw new ComponentException(e);
        }
    }

    protected <V> V getArrayInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type) {
        Class<?> ct = type.getComponentType();
        Collection<?> instances = habitat.isContract(ct) ? this.getAllByContract(onBehalfOf, habitat, ct) : this.getAllByType(onBehalfOf, habitat, ct);
        V result = type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
        return result;
    }

    protected <V> V getHolderInjectValue(Habitat habitat, Object component, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Class<V> type, Inject inject) throws ComponentException {
        Type t = Types.getTypeArgument(genericType, 0);
        Class finalType = Types.erasure(t);
        if (habitat.isContract(finalType)) {
            ContractLocatorImpl contractLocator = new ContractLocatorImpl((SimpleServiceLocator)habitat, t, true);
            this.populateContractLocator(contractLocator, target, inject);
            return type.cast(contractLocator.getProvider());
        }
        try {
            if (finalType.cast(component) != null) {
                return type.cast(onBehalfOf);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ContractLocatorImpl contractLocator = new ContractLocatorImpl((SimpleServiceLocator)habitat, finalType, false);
        return type.cast(contractLocator.getProvider());
    }

    protected <V> Provider<V> getProviderByContract(Habitat habitat, Inhabitant<?> onBehalfOf, AnnotatedElement target, Type genericType, Inject inject) throws ComponentException {
        ContractLocatorImpl contractLocator = new ContractLocatorImpl((SimpleServiceLocator)habitat, genericType, true);
        this.populateContractLocator(contractLocator, target, inject);
        return contractLocator.getProvider();
    }

    protected <V> V validate(Object component, Inhabitant<?> onBehalfOf, V toBeInjected) {
        Inhabitants.validate(component, toBeInjected);
        return toBeInjected;
    }

    protected Inhabitant<?> manage(Inhabitant<?> onBehalfOf, Inhabitant<?> inhabitant) {
        return inhabitant;
    }

    protected <V> Collection<V> manage(Inhabitant<?> onBehalfOf, Iterable<?> inhabitants) {
        if (null == inhabitants) {
            return null;
        }
        ArrayList managed = new ArrayList();
        for (Object iObj : inhabitants) {
            Inhabitant i = (Inhabitant)iObj;
            managed.add(this.manage(onBehalfOf, i).get());
        }
        return managed;
    }

    protected <V> Collection<V> getAllByType(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getInhabitantsByType(ct));
    }

    protected <V> Collection<V> getAllByContract(Inhabitant<?> onBehalfOf, Habitat habitat, Class<V> ct) {
        return this.manage(onBehalfOf, habitat.getInhabitantsByContract(ct.getName()));
    }

    void populateContractLocator(ContractLocatorImpl contractLocator, AnnotatedElement target, Inject inject) {
        Named named = target.getAnnotation(Named.class);
        String name = inject.name();
        if (named != null && !inject.name().isEmpty()) {
            throw new RuntimeException("Field or method [" + target.toString() + "] is annotated with both a @Named" + " annotation as well as a @Inject.name() value, please choose");
        }
        if (named != null) {
            name = named.value();
        }
        contractLocator.named(name);
        Annotation[] targetAnnotations = target.getAnnotations();
        if (name.isEmpty() && targetAnnotations.length > 1) {
            for (Annotation annotation : target.getAnnotations()) {
                for (Annotation annotationAnnotation : annotation.annotationType().getAnnotations()) {
                    if (annotationAnnotation.annotationType() != Qualifier.class) continue;
                    contractLocator.annotatedWith(annotation.annotationType());
                }
            }
        }
    }
}

