/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InhabitantTracker;
import org.jvnet.hk2.component.InhabitantTrackerContext;
import org.jvnet.hk2.component.InhabitantTrackerImpl;

class InhabitantTrackerJob
implements Future<InhabitantTracker>,
Callable<InhabitantTracker>,
InhabitantTracker.Callback {
    private final Habitat h;
    private final ExecutorService exec;
    volatile InhabitantTrackerImpl it;
    private final InhabitantTrackerContext itc;
    private Long timeout;

    InhabitantTrackerJob(Habitat h, InhabitantTrackerContext itc) {
        this.h = h;
        this.exec = h.getComponent(ExecutorService.class, "habitat-listeners");
        this.itc = itc;
    }

    public String toString() {
        this.isDone();
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.it + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean arg) {
        if (null != this.it) {
            InhabitantTrackerImpl inhabitantTrackerImpl = this.it;
            synchronized (inhabitantTrackerImpl) {
                this.timeout = 0L;
                this.it.notify();
            }
            this.it.release();
        }
        return true;
    }

    @Override
    public InhabitantTracker get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            this.timeout = null;
            this.exec.submit(this).get();
        }
        return this.isDone() ? this.it : null;
    }

    @Override
    public InhabitantTracker get(long timeout, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.isDone()) {
            this.timeout = units.convert(timeout, TimeUnit.MILLISECONDS);
            if (0L == timeout) {
                return null;
            }
            this.exec.submit(this).get();
        }
        return this.isDone() ? this.it : null;
    }

    @Override
    public boolean isCancelled() {
        return true;
    }

    @Override
    public boolean isDone() {
        if (null == this.it) {
            this.it = new InhabitantTrackerImpl(this.h, this.itc, this);
        }
        return this.it.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(InhabitantTracker t, Habitat h, boolean initial) {
        if (null != this.it) {
            InhabitantTrackerImpl inhabitantTrackerImpl = this.it;
            synchronized (inhabitantTrackerImpl) {
                this.it.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InhabitantTracker call() throws Exception {
        if (null != this.it) {
            InhabitantTrackerImpl inhabitantTrackerImpl = this.it;
            synchronized (inhabitantTrackerImpl) {
                if (!this.isDone()) {
                    if (null == this.timeout) {
                        this.it.wait();
                    } else {
                        this.it.wait(this.timeout);
                    }
                }
            }
        }
        return this.it;
    }
}

