/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelException;
import org.jvnet.hk2.component.RunLevelState;

public class RunLevelInhabitant<T, V>
extends EventPublishingInhabitant<T> {
    private static boolean enabled = true;
    private final int runLevel;
    private final RunLevelState<V> state;

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state) {
        this(delegate, runLevel, state, null);
    }

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state, InhabitantListener listener) {
        super(delegate, listener);
        this.runLevel = runLevel;
        this.state = state;
    }

    public static void enable(boolean enable) {
        enabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends T> type() {
        boolean wasInstantiated = this.isActive();
        try {
            Class clazz = super.type();
            return clazz;
        }
        finally {
            if (this.isActive() != wasInstantiated) {
                this.verifyState();
            }
        }
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        this.verifyState();
        return super.get(onBehalfOf);
    }

    @Override
    public <U> U getByType(Class<U> type) {
        if (this.isStrict()) {
            if (type.isInterface()) {
                this.attemptToActivate();
                return (U)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] objects) throws Throwable {
                        if (RunLevelInhabitant.this.isActive()) {
                            Object o = RunLevelInhabitant.this.get();
                            return o == null ? null : method.invoke(o, objects);
                        }
                        throw new RunLevelException(RunLevelInhabitant.this.getFailedActivationMessage(RunLevelInhabitant.this.getPlannedRunLevel(), RunLevelInhabitant.this.getCurrentRunLevel()));
                    }
                });
            }
            throw new RunLevelException("can't create proxy of type " + type + " for " + this);
        }
        return super.getByType(type);
    }

    protected void verifyState() throws ComponentException {
        Integer current;
        Integer planned;
        if (enabled && !this.isActive() && !this.isValidActiveState(planned = this.getPlannedRunLevel(), current = this.getCurrentRunLevel())) {
            throw new RunLevelException(this.getFailedActivationMessage(planned, current));
        }
    }

    private void attemptToActivate() {
        if (this.isValidActiveState(this.getPlannedRunLevel(), this.getCurrentRunLevel())) {
            this.get();
        }
    }

    private boolean isValidActiveState(Integer planned, Integer current) {
        return !this.isStrict() || this.runLevel <= planned && this.runLevel <= current + 1;
    }

    private String getFailedActivationMessage(Integer planned, Integer current) {
        return "unable to activate " + this + "; minimum expected RunLevel is: " + this.runLevel + "; planned is: " + planned + "; current is: " + current;
    }

    private boolean isStrict() {
        RunLevel rl = this.type().getAnnotation(RunLevel.class);
        return rl == null || rl.strict();
    }

    private Integer getPlannedRunLevel() {
        Integer planned = this.state.getPlannedRunLevel();
        return planned == null ? -1 : planned;
    }

    private Integer getCurrentRunLevel() {
        Integer current = this.state.getCurrentRunLevel();
        return current == null ? -1 : current;
    }

    public RunLevelState<?> getState() {
        return this.state;
    }
}

