/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;

class RunLevelServiceStub
implements RunLevelService,
RunLevelState,
InhabitantListener {
    private final Habitat h;
    private final String scopeName;
    private RunLevelService delegate;
    private InhabitantListener delegateListener;

    RunLevelServiceStub(Habitat habitat, String scopeName) {
        this.h = habitat;
        this.scopeName = scopeName;
    }

    public RunLevelService getDelegate() {
        return this.delegate;
    }

    void activate(RunLevelService<?> realRls) {
        this.delegate = realRls;
        if (InhabitantListener.class.isInstance(this.delegate)) {
            this.delegateListener = (InhabitantListener)InhabitantListener.class.cast(this.delegate);
        }
    }

    Habitat getHabitat() {
        return this.h;
    }

    public RunLevelState getState() {
        return this;
    }

    @Override
    public Integer getCurrentRunLevel() {
        return null == this.delegate ? null : this.delegate.getState().getCurrentRunLevel();
    }

    @Override
    public Integer getPlannedRunLevel() {
        return null == this.delegate ? null : this.delegate.getState().getPlannedRunLevel();
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public void proceedTo(int runLevel) {
        if (null != this.delegate) {
            this.delegate.proceedTo(runLevel);
        }
        throw new IllegalStateException();
    }

    @Override
    public void interrupt() {
        if (null != this.delegate) {
            this.delegate.interrupt();
        }
        throw new IllegalStateException();
    }

    @Override
    public void interrupt(int runLevel) {
        if (null != this.delegate) {
            this.delegate.interrupt(runLevel);
        }
        throw new IllegalStateException();
    }

    @Override
    public synchronized boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (null == this.delegateListener) {
            if (null == this.delegate) {
                return true;
            }
            if (InhabitantListener.class.isInstance(this.delegate)) {
                this.delegateListener = (InhabitantListener)InhabitantListener.class.cast(this.delegate);
            } else {
                return false;
            }
        }
        return this.delegateListener.inhabitantChanged(eventType, inhabitant);
    }
}

