/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractCreatorImpl;
import com.sun.hk2.component.Hk2ThreadContext;
import java.security.AccessControlContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Factory;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.ContextualFactory;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionPoint;
import org.jvnet.hk2.component.MultiMap;

public class FactoryCreator<T>
extends AbstractCreatorImpl<T> {
    private static final Logger logger = Logger.getLogger(FactoryCreator.class.getName());
    private final Inhabitant<? extends Factory> factory;

    public FactoryCreator(Class<T> type, Class<? extends Factory> factory, Habitat habitat, MultiMap<String, String> metadata) {
        this(type, habitat.getInhabitantByType(factory), habitat, metadata);
    }

    public FactoryCreator(Class<T> type, Inhabitant<? extends Factory> factory, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
        assert (factory != null);
        assert (habitat != null);
        this.factory = factory;
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        logger.log(Level.FINER, "factory {0} invoked", this.factory);
        Factory f = this.factory.get();
        AccessControlContext acc = Hk2ThreadContext.getCallerACC();
        InjectionPoint ip = Hk2ThreadContext.getCallerIP();
        Object t = ContextualFactory.class.isInstance(f) && (null != ip || null != acc) ? this.type.cast(((ContextualFactory)ContextualFactory.class.cast(f)).getObject(ip, acc)) : this.type.cast(f.get());
        if (null == t) {
            return null;
        }
        this.inject(this.habitat, t, onBehalfOf);
        return t;
    }
}

