/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creators;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

public class InjectableParametizedConstructorCreator<T>
extends ConstructorCreator<T> {
    final Constructor<T> ctor;

    public InjectableParametizedConstructorCreator(Class<T> type, Constructor<T> ctor, Habitat habitat, MultiMap<String, String> metadata) {
        super(type, habitat, metadata);
        this.ctor = ctor;
    }

    @Override
    public T create(Inhabitant onBehalfOf) throws ComponentException {
        Annotation[][] paramsAnnotations = this.ctor.getParameterAnnotations();
        Class<?>[] paramTypes = this.ctor.getParameterTypes();
        Type[] genericParamTypes = this.ctor.getGenericParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        int firstIndex = paramTypes.length - genericParamTypes.length;
        paramValues[0] = null;
        for (int i = 0; i < genericParamTypes.length; ++i) {
            Class<?> paramType = paramTypes[i + firstIndex];
            final Annotation[] paramAnnotations = paramsAnnotations[i];
            boolean nonOptionalInjection = false;
            for (Inhabitant<? extends InjectionResolver> resolverInhabitant : Creators.getAllInjectionResolvers(this.habitat)) {
                InjectionResolver resolver = resolverInhabitant.get();
                Object a = this.getAnnotation(resolver.type, paramAnnotations);
                if (a == null) continue;
                AnnotatedElement annotatedElement = new AnnotatedElement(){

                    @Override
                    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                        return this.getAnnotation(annotationClass) != null;
                    }

                    @Override
                    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                        return (T)InjectableParametizedConstructorCreator.this.getAnnotation(annotationClass, paramAnnotations);
                    }

                    @Override
                    public Annotation[] getAnnotations() {
                        return paramAnnotations;
                    }

                    @Override
                    public Annotation[] getDeclaredAnnotations() {
                        return paramAnnotations;
                    }
                };
                Object value = resolver.getValue(this, onBehalfOf, annotatedElement, genericParamTypes[i], paramType);
                if (value != null) {
                    paramValues[i + firstIndex] = value;
                    break;
                }
                nonOptionalInjection = !resolver.isOptional(annotatedElement, a);
            }
            if (paramValues[i + firstIndex] != null || !nonOptionalInjection) continue;
            throw new UnsatisfiedDependencyException(this.ctor, null, (Throwable)((Object)new UnsatisfiedDependencyException(genericParamTypes[i + firstIndex], paramTypes[i + firstIndex], null, null)));
        }
        try {
            return this.ctor.newInstance(paramValues);
        }
        catch (InvocationTargetException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (InstantiationException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (IllegalAccessException e) {
            try {
                this.ctor.setAccessible(true);
                return this.ctor.newInstance(paramValues);
            }
            catch (Exception e1) {
                throw new ComponentException("Failed to create " + this.type, e);
            }
        }
        catch (LinkageError e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
        catch (RuntimeException e) {
            throw new ComponentException("Failed to create " + this.type, e);
        }
    }

    private <U extends Annotation> U getAnnotation(Class<U> annotationType, Annotation[] paramAnnotation) {
        if (this.ctor.isAnnotationPresent(annotationType)) {
            return (U)this.ctor.getAnnotation(annotationType);
        }
        for (Annotation a : paramAnnotation) {
            if (!a.annotationType().equals(annotationType)) continue;
            return (U)((Annotation)annotationType.cast(a));
        }
        return null;
    }
}

