/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.glassfish.hk2.Descriptor;
import org.glassfish.hk2.Scope;
import org.jvnet.hk2.component.MultiMap;

public class DescriptorImpl
implements Descriptor {
    private final LinkedHashSet<String> names;
    private final String typeName;
    private final LinkedHashSet<String> qualifiers;
    private final LinkedHashSet<String> contracts;
    private final MultiMap<String, String> metadata;
    private final Scope scope;
    private boolean readOnly;
    static final Descriptor EMPTY_DESCRIPTOR = new Descriptor(){

        public Collection<String> getNames() {
            return Collections.emptySet();
        }

        public MultiMap<String, String> getMetadata() {
            return MultiMap.emptyMap();
        }

        public Collection<String> getQualifiers() {
            return Collections.emptySet();
        }

        public Collection<String> getContracts() {
            return Collections.emptySet();
        }

        public String getTypeName() {
            return null;
        }

        public Scope getScope() {
            return null;
        }

        public boolean hasName(String name) {
            return false;
        }

        public boolean hasQualifier(String qualifier) {
            return false;
        }

        public boolean hasContract(String contract) {
            return false;
        }
    };

    public DescriptorImpl() {
        this(null, null, null, null);
    }

    public DescriptorImpl(Class<?> type) {
        this(null, type.getName(), null, null);
    }

    public DescriptorImpl(String name, String typeName) {
        this(name, typeName, null, null);
    }

    public DescriptorImpl(String name, String typeName, MultiMap<String, String> metadata, Scope scope) {
        this(null, typeName, metadata, scope, null, null);
        if (null != name) {
            this.addName(name);
        }
    }

    public DescriptorImpl(Descriptor other) {
        this(other, false);
    }

    public DescriptorImpl(Descriptor other, boolean readOnly) {
        this.names = new LinkedHashSet(other.getNames());
        this.typeName = other.getTypeName();
        this.scope = other.getScope();
        this.qualifiers = new LinkedHashSet(other.getQualifiers());
        this.contracts = new LinkedHashSet(other.getContracts());
        this.metadata = null == other.getMetadata() || MultiMap.emptyMap() == other.getMetadata() ? MultiMap.emptyMap() : new MultiMap(other.getMetadata());
        if (readOnly) {
            this.setReadOnly();
        }
    }

    private DescriptorImpl(LinkedHashSet<String> names, String typeName, MultiMap<String, String> metadata, Scope scope, LinkedHashSet<String> qualifiers, LinkedHashSet<String> contracts) {
        this.names = null == names ? new LinkedHashSet() : names;
        this.typeName = typeName;
        this.scope = scope;
        this.qualifiers = null == qualifiers ? new LinkedHashSet() : qualifiers;
        this.contracts = null == contracts ? new LinkedHashSet() : contracts;
        this.metadata = null == metadata ? new MultiMap() : metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, "names", this.names);
        this.append(sb, "typeName", this.typeName);
        this.append(sb, "scope", this.scope);
        this.append(sb, "qualifiers", this.qualifiers);
        this.append(sb, "contracts", this.contracts);
        this.append(sb, "metadata", this.metadata);
        return sb.toString();
    }

    public int hashCode() {
        return null == this.typeName ? -1 : this.typeName.hashCode();
    }

    public boolean equals(Object another) {
        if (!Descriptor.class.isInstance(another)) {
            return false;
        }
        Descriptor d = (Descriptor)Descriptor.class.cast(another);
        return DescriptorImpl.equals(this.getNames(), d.getNames()) && DescriptorImpl.equals(this.getTypeName(), d.getTypeName()) && DescriptorImpl.equals(this.getMetadata(), d.getMetadata()) && DescriptorImpl.equals(this.getScope(), d.getScope()) && DescriptorImpl.equals(this.getContracts(), d.getContracts()) && DescriptorImpl.equals(this.getQualifiers(), d.getQualifiers());
    }

    private void append(StringBuilder sb, String key, Object val) {
        if (null != val) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(key).append("=").append(val);
        }
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    protected void assertNotReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
    }

    public DescriptorImpl addName(String name) {
        this.assertNotReadOnly();
        this.names.add(name);
        return this;
    }

    public DescriptorImpl addContract(Class<?> clazz) {
        return this.addContract(clazz.getName());
    }

    public DescriptorImpl addContract(String contractFQCN) {
        this.assertNotReadOnly();
        this.contracts.add(contractFQCN);
        return this;
    }

    public DescriptorImpl addQualifierType(String annotation) {
        this.assertNotReadOnly();
        this.qualifiers.add(annotation);
        return this;
    }

    public DescriptorImpl addMetadata(String key, String value) {
        this.assertNotReadOnly();
        this.metadata.add(key, value);
        return this;
    }

    public Collection<String> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public Scope getScope() {
        return this.scope;
    }

    public MultiMap<String, String> getMetadata() {
        return this.metadata.readOnly();
    }

    public Collection<String> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Collection<String> getContracts() {
        return Collections.unmodifiableSet(this.contracts);
    }

    public boolean hasName(String name) {
        return this.names.contains(name);
    }

    public boolean hasQualifier(String qualifier) {
        return this.qualifiers.contains(qualifier);
    }

    public boolean hasContract(String contract) {
        return this.contracts.contains(contract);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean matches(Descriptor another) {
        return DescriptorImpl.matches(this, another);
    }

    public static boolean matches(Descriptor d1, Descriptor d2) {
        if (null == d1 && null == d2) {
            return true;
        }
        if (null == d1 || null == d2) {
            return false;
        }
        return DescriptorImpl.matches(d1.getNames(), d2.getNames()) && DescriptorImpl.matches(d1.getTypeName(), d2.getTypeName()) && DescriptorImpl.matches(d1.getScope(), d2.getScope()) && DescriptorImpl.matches(d1.getQualifiers(), d2.getQualifiers()) && DescriptorImpl.matches(d1.getContracts(), d2.getContracts()) && DescriptorImpl.matches(d1.getMetadata(), d2.getMetadata());
    }

    private static boolean matches(Object o1, Object o2) {
        if (null == o1) {
            return true;
        }
        if (Collection.class.isInstance(o1)) {
            Collection c1 = (Collection)Collection.class.cast(o1);
            if (Collection.class.isInstance(o2)) {
                return DescriptorImpl.matches(c1, (Collection)Collection.class.cast(o2));
            }
        } else if (MultiMap.class.isInstance(o1) && org.glassfish.hk2.MultiMap.class.isInstance(o2)) {
            return ((MultiMap)MultiMap.class.cast(o1)).matches((org.glassfish.hk2.MultiMap)org.glassfish.hk2.MultiMap.class.cast(o2));
        }
        return DescriptorImpl.equals(o1, o2);
    }

    private static boolean matches(Collection<?> c1, Collection<?> c2) {
        if (null == c1 && null == c2) {
            return true;
        }
        if (null == c1 || null == c2) {
            return false;
        }
        if (c1.size() > c2.size()) {
            return false;
        }
        for (Object o : c1) {
            if (c2.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Descriptor descriptor) {
        if (null == descriptor || EMPTY_DESCRIPTOR == descriptor) {
            return true;
        }
        if (!DescriptorImpl.isEmpty(descriptor.getNames()) || !DescriptorImpl.isEmpty(descriptor.getTypeName())) {
            return false;
        }
        if (!DescriptorImpl.isEmpty(descriptor.getContracts()) || !DescriptorImpl.isEmpty(descriptor.getQualifiers())) {
            return false;
        }
        if (null != descriptor.getMetadata() && descriptor.getMetadata().size() > 0) {
            return false;
        }
        return null == descriptor.getScope();
    }

    static boolean isEmpty(Collection<String> coll) {
        return null == coll || coll.isEmpty();
    }

    static boolean isEmpty(String val) {
        return null == val || val.isEmpty();
    }

    private static boolean equals(Object o1, Object o2) {
        if (null == o1 && null == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (o1.getClass() != o2.getClass() && Collection.class.isInstance(o1)) {
            Collection c1 = (Collection)Collection.class.cast(o1);
            Collection c2 = (Collection)Collection.class.cast(o2);
            if (c1.size() != c2.size()) {
                return false;
            }
            Iterator it1 = c1.iterator();
            Iterator it2 = c2.iterator();
            while (it1.hasNext()) {
                if (it1.next().equals(it2.next())) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static DescriptorImpl createMerged(Descriptor d1, Descriptor d2) {
        if (null == d1 && null == d2) {
            return null;
        }
        if (null == d1) {
            return new DescriptorImpl(d2);
        }
        if (null == d2) {
            return new DescriptorImpl(d1);
        }
        LinkedHashSet<String> names = DescriptorImpl.getMergedSet(d1.getNames(), d2.getNames());
        String typeName = DescriptorImpl.getMerged(d1.getTypeName(), d2.getTypeName());
        Scope scope = DescriptorImpl.getMerged(d1.getScope(), d2.getScope());
        MultiMap<String, String> metadata = DescriptorImpl.getMergedMetaData((org.glassfish.hk2.MultiMap<String, String>)d1.getMetadata(), (org.glassfish.hk2.MultiMap<String, String>)d2.getMetadata());
        LinkedHashSet<String> qualifiers = DescriptorImpl.getMergedSet(d1.getQualifiers(), d2.getQualifiers());
        LinkedHashSet<String> contracts = DescriptorImpl.getMergedSet(d1.getContracts(), d2.getContracts());
        return new DescriptorImpl(names, typeName, metadata, scope, qualifiers, contracts);
    }

    private static MultiMap<String, String> getMergedMetaData(org.glassfish.hk2.MultiMap<String, String> m1, org.glassfish.hk2.MultiMap<String, String> m2) {
        if (null == m1 && null == m2) {
            return null;
        }
        MultiMap<String, String> mm = new MultiMap<String, String>();
        if (null != m1) {
            mm.mergeAll(m1);
        }
        if (null != m2) {
            mm.mergeAll(m2);
        }
        return mm;
    }

    private static LinkedHashSet<String> getMergedSet(Collection<String> s1, Collection<String> s2) {
        if (null == s1 && null == s2) {
            return null;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (null != s1) {
            set.addAll(s1);
        }
        if (null != s2) {
            set.addAll(s2);
        }
        return set;
    }

    static <T> T getMerged(T v1, T v2) {
        if (null == v1) {
            return v2;
        }
        if (null == v2) {
            return v1;
        }
        if (!v1.equals(v2)) {
            throw new IllegalStateException("can't merge " + v1 + " and " + v2);
        }
        return v1;
    }
}

