/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;

public class TypeProxy<T extends Type> {
    private T value = null;
    private volatile boolean visited = false;
    private final String name;
    private final Notifier<T> notifier;
    private final List<Member> fieldRefs = new ArrayList<Member>();
    private final List<Type> subTypeRefs = new ArrayList<Type>();
    private final List<ClassModel> implementations = new ArrayList<ClassModel>();

    TypeProxy(Notifier<T> notifier, String name) {
        this.notifier = notifier;
        this.name = name;
    }

    public String toString() {
        return "TypeProxy:" + this.name;
    }

    public void set(T value) {
        this.value = value;
        if (this.notifier != null) {
            this.notifier.valueSet(value);
        }
    }

    public T get() {
        return this.value;
    }

    public String getName() {
        if (this.value != null) {
            return this.value.getName();
        }
        return this.name;
    }

    public synchronized void addFieldRef(FieldModel field) {
        this.fieldRefs.add(field);
    }

    public List<Member> getRefs() {
        return Collections.unmodifiableList(this.fieldRefs);
    }

    public synchronized void addSubTypeRef(Type subType) {
        this.subTypeRefs.add(subType);
    }

    public List<Type> getSubTypeRefs() {
        return Collections.unmodifiableList(this.subTypeRefs);
    }

    public synchronized void addImplementation(ClassModel classModel) {
        this.implementations.add(classModel);
    }

    public List<ClassModel> getImplementations() {
        return Collections.unmodifiableList(this.implementations);
    }

    public static <U extends Type> Collection<U> adapter(final Collection<TypeProxy<U>> source) {
        return new AbstractCollection<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator itr = source.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return itr.hasNext();
                    }

                    @Override
                    public U next() {
                        TypeProxy next = (TypeProxy)itr.next();
                        if (next != null) {
                            return next.get();
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }

    public void visited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public static interface Notifier<T> {
        public void valueSet(T var1);
    }
}

