/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.enterprise.tools.apt.ContractFinder;
import com.sun.istack.tools.APTTypeVisitor;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.Types;
import com.sun.tools.xjc.api.util.FilerCodeWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.NoopConfigInjector;
import org.jvnet.hk2.config.generator.Property;
import org.jvnet.hk2.config.generator.TypeMath;

public class ConfigInjectorGenerator
extends SimpleDeclarationVisitor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;
    private JCodeModel cm;
    final TypeMath math;
    private final TypeDeclaration configBeanProxy;
    final APTTypeVisitor<JType, Void> TO_JTYPE = new APTTypeVisitor<JType, Void>(){

        protected JType onPrimitiveType(PrimitiveType type, Void param) {
            switch (type.getKind()) {
                case BOOLEAN: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.BOOLEAN;
                }
                case BYTE: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.BYTE;
                }
                case CHAR: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.CHAR;
                }
                case DOUBLE: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.DOUBLE;
                }
                case FLOAT: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.FLOAT;
                }
                case INT: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.INT;
                }
                case LONG: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.LONG;
                }
                case SHORT: {
                    return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.SHORT;
                }
            }
            throw new AssertionError();
        }

        protected JType onArrayType(ArrayType type, Void param) {
            return ((JType)this.apply(type.getComponentType(), null)).array();
        }

        protected JType onClassType(ClassType type, Void param) {
            return ConfigInjectorGenerator.this.cm.ref(type.getDeclaration().getQualifiedName());
        }

        protected JType onInterfaceType(InterfaceType type, Void param) {
            return ConfigInjectorGenerator.this.cm.ref(type.getDeclaration().getQualifiedName());
        }

        protected JType onTypeVariable(TypeVariable type, Void param) {
            throw new UnsupportedOperationException();
        }

        protected JType onVoidType(VoidType type, Void param) {
            return ((ConfigInjectorGenerator)ConfigInjectorGenerator.this).cm.VOID;
        }

        protected JType onWildcard(WildcardType type, Void param) {
            throw new UnsupportedOperationException();
        }
    };

    public ConfigInjectorGenerator(AnnotationProcessorEnvironment env) {
        this.env = env;
        this.math = new TypeMath(env);
        this.configBeanProxy = env.getTypeDeclaration(ConfigBeanProxy.class.getName());
    }

    public void process() {
        this.cm = new JCodeModel();
        AnnotationTypeDeclaration ann = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(Configured.class.getName());
        for (Declaration d : this.env.getDeclarationsAnnotatedWith(ann)) {
            d.accept((DeclarationVisitor)this);
        }
        try {
            this.cm.build((CodeWriter)new FilerCodeWriter(this.env.getFiler()));
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.cm = null;
    }

    public void visitClassDeclaration(ClassDeclaration clz) {
        try {
            new ClassGenerator((TypeDeclaration)clz, false).generate();
        }
        catch (JClassAlreadyExistsException e) {
            this.env.getMessager().printError(clz.getPosition(), e.toString());
        }
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration clz) {
        try {
            if (!this.isSubType((TypeDeclaration)clz, this.configBeanProxy)) {
                this.env.getMessager().printError(clz.getPosition(), clz.getQualifiedName() + " has @Configured but doesn't extend ConfigBeanProxy");
            } else {
                new ClassGenerator((TypeDeclaration)clz, true).generate();
            }
        }
        catch (JClassAlreadyExistsException e) {
            this.env.getMessager().printError(clz.getPosition(), e.toString());
        }
    }

    private boolean isSubType(TypeDeclaration subType, TypeDeclaration baseType) {
        Types u = this.env.getTypeUtils();
        return u.isSubtype((TypeMirror)u.getDeclaredType(subType, new TypeMirror[0]), (TypeMirror)u.getDeclaredType(baseType, new TypeMirror[0]));
    }

    private static String getCanonicalTypeFrom(MirroredTypeException me) {
        TypeMirror tm = me.getTypeMirror();
        if (tm instanceof DeclaredType) {
            DeclaredType dec = (DeclaredType)tm;
            String qn = dec.getDeclaration().getQualifiedName();
            return qn;
        }
        return "";
    }

    private TypeMirror erasure(TypeMirror type) {
        return this.env.getTypeUtils().getErasure(type);
    }

    class ClassGenerator {
        final TypeDeclaration clz;
        final JDefinedClass injector;
        final JClass targetType;
        final JAnnotationUse service;
        final JMethod injectMethod;
        final JMethod injectAttributeMethod;
        final JMethod injectElementMethod;
        final MultiMap<String, String> metadata = new MultiMap();
        private Property key = null;
        private final boolean generateNoopConfigInjector;

        public ClassGenerator(TypeDeclaration clz, boolean generateNoopConfigInjector) throws JClassAlreadyExistsException {
            this.clz = clz;
            this.generateNoopConfigInjector = generateNoopConfigInjector;
            Configured c = (Configured)clz.getAnnotation(Configured.class);
            String name = clz.getQualifiedName();
            this.targetType = ConfigInjectorGenerator.this.cm.ref(name);
            this.injector = ConfigInjectorGenerator.this.cm._class(name + "Injector");
            String elementName = c.name();
            if (c.local()) {
                if (elementName.length() > 0) {
                    ConfigInjectorGenerator.this.env.getMessager().printError(clz.getPosition(), "@Configured.local and @Configured.name is mutually exclusive");
                    elementName = "";
                }
            } else if (elementName.length() == 0) {
                elementName = Dom.convertName((String)clz.getSimpleName());
            }
            this.service = this.injector.annotate(Service.class).param("name", elementName);
            this.injector.annotate(InjectionTarget.class).param("value", (JType)this.targetType);
            if (generateNoopConfigInjector) {
                this.injector._extends(ConfigInjectorGenerator.this.cm.ref(NoopConfigInjector.class));
                this.injectAttributeMethod = null;
                this.injectMethod = null;
                this.injectElementMethod = null;
            } else {
                this.injector._extends(ConfigInjectorGenerator.this.cm.ref(ConfigInjector.class).narrow(this.targetType));
                this.injectMethod = this.injector.method(1, Void.TYPE, "inject");
                this.injectMethod.param(Dom.class, "dom");
                this.injectMethod.param((JType)this.targetType, "target");
                this.injectMethod.body();
                this.injectAttributeMethod = this.injector.method(1, Void.TYPE, "injectAttribute");
                this.addReinjectionParam(this.injectAttributeMethod);
                this.injectElementMethod = this.injector.method(1, Void.TYPE, "injectElement");
                this.addReinjectionParam(this.injectElementMethod);
            }
            this.metadata.add((Object)"target", (Object)name);
            for (TypeDeclaration t : ContractFinder.find((TypeDeclaration)clz)) {
                this.metadata.add((Object)"target-contracts", (Object)t.getQualifiedName());
            }
        }

        private void addReinjectionParam(JMethod method) {
            method.param(Dom.class, "dom");
            method.param(String.class, "name");
            method.param((JType)this.targetType, "target");
        }

        public void generate() {
            Stack<Object> q = new Stack<Object>();
            HashSet<TypeDeclaration> visited = new HashSet<TypeDeclaration>();
            q.push(this.clz);
            while (!q.isEmpty()) {
                ClassDeclaration cd;
                TypeDeclaration t = (TypeDeclaration)q.pop();
                if (!visited.add(t)) continue;
                for (FieldDeclaration f : t.getFields()) {
                    this.generate(new Property.Field(f));
                }
                for (MethodDeclaration m : t.getMethods()) {
                    this.generate(new Property.Method(m));
                }
                for (InterfaceType it : this.clz.getSuperinterfaces()) {
                    q.add(it.getDeclaration());
                }
                if (!(t instanceof ClassDeclaration) || (cd = (ClassDeclaration)t).getSuperclass() == null) continue;
                q.add(cd.getSuperclass().getDeclaration());
            }
            this.service.param("metadata", this.metadata.toCommaSeparatedString());
        }

        private void generate(Property p) {
            Attribute a = p.getAnnotation(Attribute.class);
            Element e = p.getAnnotation(Element.class);
            if (a != null) {
                new AttributeMethodGenerator(p, a).generate();
                if (e != null) {
                    ConfigInjectorGenerator.this.env.getMessager().printError(p.decl().getPosition(), "Cannot have both @Element and @Attribute at the same time");
                }
            } else if (e != null) {
                new ElementMethodGenerator(p, e).generate();
            }
            if (p.isKey()) {
                if (this.key != null) {
                    ConfigInjectorGenerator.this.env.getMessager().printError(p.decl().getPosition(), "Multiple key properties");
                    ConfigInjectorGenerator.this.env.getMessager().printError(this.key.decl().getPosition(), "Another one is at here");
                }
                this.key = p;
            }
        }

        private final class ElementMethodGenerator
        extends MethodGenerator {
            private final Element e;

            private ElementMethodGenerator(Property p, Element e) {
                super("element_", ClassGenerator.this.injectElementMethod, p, e.value());
                this.e = e;
            }

            @Override
            protected String xmlTokenName() {
                return '<' + this.xmlName + '>';
            }

            @Override
            protected JExpression getXmlValue() {
                String name;
                if (this.conv.isLeaf()) {
                    name = this.isVariableExpansion() ? "leafElement" : "rawLeafElement";
                } else {
                    assert (this.isVariableExpansion());
                    if (this.xmlName.equals("*")) {
                        return this.invokeDom("nodeByTypeElement").arg(((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(this.itemType, null)).boxify().dotclass());
                    }
                    name = "nodeElement";
                }
                return this.invokeDom(name).arg(this.xmlName);
            }

            @Override
            protected void generate() {
                super.generate();
                if (this.packer == null) {
                    for (AnnotationMirror am : this.p.decl().getAnnotationMirrors()) {
                        if (am.toString().contains("hk2")) continue;
                        ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)am.toString());
                    }
                }
            }

            @Override
            protected boolean isRequired() {
                return this.e.required();
            }

            @Override
            protected boolean isReference() {
                return this.e.reference();
            }

            @Override
            protected boolean isVariableExpansion() {
                return this.e.variableExpansion();
            }

            @Override
            protected boolean isAllElementMatch() {
                return this.e.value().equals("*");
            }
        }

        private final class AttributeMethodGenerator
        extends MethodGenerator {
            private final Attribute a;

            private AttributeMethodGenerator(Property p, Attribute a) {
                super("attribute_", ClassGenerator.this.injectAttributeMethod, p, a.value());
                this.a = a;
            }

            @Override
            protected String xmlTokenName() {
                return '@' + this.xmlName;
            }

            @Override
            protected boolean isRequired() {
                return this.a.required();
            }

            @Override
            protected boolean isReference() {
                return this.a.reference();
            }

            @Override
            protected boolean isVariableExpansion() {
                return this.a.variableExpansion();
            }

            @Override
            protected boolean isAllElementMatch() {
                return false;
            }

            protected boolean hasDefault() {
                boolean noDefaultValue = this.a.defaultValue().length() == 1 && this.a.defaultValue().charAt(0) == '\u0000';
                return !noDefaultValue;
            }

            @Override
            protected void generate() {
                ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)(this.isRequired() ? "required" : "optional"));
                if (this.hasDefault()) {
                    if (this.a.defaultValue().indexOf(44) != -1) {
                        ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)("\"default:" + this.a.defaultValue() + '\"'));
                    } else {
                        ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)("default:" + this.a.defaultValue()));
                    }
                }
                String ant = "";
                try {
                    Class c = this.a.dataType();
                }
                catch (MirroredTypeException me) {
                    ant = ConfigInjectorGenerator.getCanonicalTypeFrom(me);
                }
                if (ant.length() == 0) {
                    Property.Method m = (Property.Method)this.p;
                    String typeReturnedByMethodDecl = m.decl.getReturnType().toString();
                    ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)("datatype:" + typeReturnedByMethodDecl));
                } else {
                    ClassGenerator.this.metadata.add((Object)this.xmlTokenName(), (Object)("datatype:" + ant));
                }
                super.generate();
            }

            @Override
            protected JExpression getXmlValue() {
                if (!this.isVariableExpansion() && this.packer != null) {
                    ConfigInjectorGenerator.this.env.getMessager().printError(this.p.decl().getPosition(), "collection attribute property is inconsistent with variableExpansion=false");
                }
                return this.invokeDom(this.isVariableExpansion() ? "attribute" : "rawAttribute").arg(this.xmlName);
            }
        }

        private abstract class MethodGenerator {
            final JBlock body;
            final JVar $dom;
            final JVar $target;
            final String xmlName;
            final Property p;
            private int iota = 1;
            final TypeMirror erasure;
            final Packer packer;
            final TypeMirror itemType;
            Converter conv;

            MethodGenerator(String methodNamePrefix, JMethod reinjectionMethod, Property p, String xmlName) {
                this.xmlName = p.inferName(xmlName);
                this.p = p;
                if (ClassGenerator.this.generateNoopConfigInjector) {
                    this.body = null;
                    this.$dom = null;
                    this.$target = null;
                } else {
                    JMethod m = ClassGenerator.this.injector.method(1, Void.TYPE, methodNamePrefix + p.seedName());
                    this.$dom = m.param(Dom.class, "dom");
                    this.$target = m.param((JType)ClassGenerator.this.targetType, "target");
                    this.body = m.body();
                    ClassGenerator.this.injectMethod.body().invoke(m).arg((JExpression)this.$dom).arg((JExpression)this.$target);
                    reinjectionMethod.body()._if((JExpression)JExpr.lit((String)this.xmlName).invoke("equals").arg((JExpression)JExpr.ref((String)"name")))._then().invoke(m).arg((JExpression)this.$dom).arg((JExpression)this.$target);
                }
                this.erasure = ConfigInjectorGenerator.this.erasure(p.type());
                this.packer = this.createPacker(p.type(), this.erasure);
                this.itemType = this.packer == null ? this.erasure : ConfigInjectorGenerator.this.erasure(this.packer.itemType());
            }

            private void assign(JExpression rhs) {
                this.p.assign(this.$target, this.body, rhs);
            }

            protected abstract String xmlTokenName();

            protected void generate() {
                this.conv = this.createConverter(this.itemType);
                this.conv.addMetadata(this.xmlTokenName(), this.itemType);
                if (!this.isVariableExpansion() && ConfigInjectorGenerator.this.TO_JTYPE.apply(this.itemType, null) != ConfigInjectorGenerator.this.cm.ref(String.class)) {
                    ConfigInjectorGenerator.this.env.getMessager().printError(this.p.decl().getPosition(), "variableExpansion=false is only allowed on String");
                }
                if (!ClassGenerator.this.generateNoopConfigInjector) {
                    JVar value = this.var((JType)(this.packer != null ? ConfigInjectorGenerator.this.cm.ref(List.class).narrow(this.conv.sourceType()) : this.conv.sourceType()), this.getXmlValue());
                    if (!this.isRequired()) {
                        this.body._if(value.eq(JExpr._null()))._then()._return();
                    }
                    if (this.packer != null) {
                        this.handleMultiValue(value);
                    } else {
                        this.assign(this.conv.as((JExpression)value, this.itemType));
                    }
                }
                if (this.p.isKey()) {
                    this.addKey();
                }
            }

            protected abstract boolean isRequired();

            protected abstract boolean isReference();

            protected abstract boolean isVariableExpansion();

            protected abstract boolean isAllElementMatch();

            protected abstract JExpression getXmlValue();

            private void addKey() {
                ClassGenerator.this.metadata.add((Object)"key", (Object)this.xmlTokenName());
                ClassGenerator.this.metadata.add((Object)"keyed-as", (Object)this.p.decl().getDeclaringType().getQualifiedName());
            }

            final JInvocation invokeDom(String methodName) {
                if (this.packer != null) {
                    methodName = methodName + 's';
                }
                return this.$dom.invoke(methodName);
            }

            private void handleMultiValue(JVar values) {
                this.packer.start((JExpression)values.invoke("size"));
                JForEach forEach = this.body.forEach((JType)this.conv.sourceType(), this.id(), (JExpression)values);
                this.packer.pack(forEach.body(), this.conv.as((JExpression)forEach.var(), this.packer.itemType()), (JExpression)forEach.var());
                this.assign(this.packer.end());
            }

            protected JVar var(JType t, JExpression init) {
                return this.body.decl(t, this.id(), init);
            }

            protected JVar var(Class t, JExpression init) {
                return this.var((JType)ConfigInjectorGenerator.this.cm.ref(t), init);
            }

            private String id() {
                return "v" + this.iota++;
            }

            private Packer createPacker(TypeMirror type, TypeMirror erasure) {
                if (erasure instanceof ArrayType) {
                    return new ArrayPacker((ArrayType)erasure);
                }
                TypeMirror itemType = ConfigInjectorGenerator.this.math.isCollection(type);
                if (itemType != null) {
                    return new ListPacker(type, itemType);
                }
                TypeMirror mapType = (TypeMirror)TypeMath.baseClassFinder.apply(type, (Object)ConfigInjectorGenerator.this.env.getTypeDeclaration(Map.class.getName()));
                if (mapType != null) {
                    DeclaredType d = (DeclaredType)mapType;
                    Iterator itr = d.getActualTypeArguments().iterator();
                    itr.next();
                    return new MapPacker((TypeMirror)itr.next());
                }
                return null;
            }

            private Converter createConverter(TypeMirror itemType) {
                try {
                    ConfigInjectorGenerator.this.math.SIMPLE_VALUE_CONVERTER.apply(itemType, (Object)JExpr._null());
                    return new LeafConverter();
                }
                catch (UnsupportedOperationException e) {
                    if (itemType instanceof DeclaredType) {
                        if (!(itemType instanceof ClassType) && !(itemType instanceof InterfaceType)) {
                            ConfigInjectorGenerator.this.env.getMessager().printError(this.p.decl().getPosition(), "I only inject interfaces or classes,  " + itemType + " is not one of them");
                            return new NodeConverter();
                        }
                        TypeDeclaration decl = ((DeclaredType)itemType).getDeclaration();
                        Configured cfg = (Configured)decl.getAnnotation(Configured.class);
                        if (cfg != null) {
                            if (this.isReference()) {
                                return new ReferenceConverter();
                            }
                            return new NodeConverter();
                        }
                    }
                    if (this.isAllElementMatch()) {
                        return new NodeByTypeConverter(itemType);
                    }
                    ConfigInjectorGenerator.this.env.getMessager().printError(this.p.decl().getPosition(), "I don't know how to inject " + itemType + " from configuration");
                    return new NodeConverter();
                }
            }

            class ReferenceConverter
            extends Converter {
                ReferenceConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return JExpr.invoke((String)"reference").arg((JExpression)MethodGenerator.this.$dom).arg(rhs).arg(((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(targetType, null)).boxify().dotclass());
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(String.class);
                }

                @Override
                boolean isLeaf() {
                    return true;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    ClassGenerator.this.metadata.add((Object)key, (Object)this.makeCollectionIfNecessary("leaf"));
                    ClassGenerator.this.metadata.add((Object)key, (Object)"reference");
                }
            }

            class NodeByTypeConverter
            extends Converter {
                final JClass sourceType;

                NodeByTypeConverter(TypeMirror sourceType) {
                    this.sourceType = ((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(sourceType, null)).boxify();
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return rhs;
                }

                @Override
                JClass sourceType() {
                    return this.sourceType;
                }

                @Override
                boolean isLeaf() {
                    return false;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                }
            }

            class NodeConverter
            extends Converter {
                NodeConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return JExpr.cast((JType)((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(targetType, null)), (JExpression)rhs.invoke("get"));
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(Dom.class);
                }

                @Override
                boolean isLeaf() {
                    return false;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    ClassGenerator.this.metadata.add((Object)key, (Object)this.makeCollectionIfNecessary(itemType.toString()));
                }
            }

            class LeafConverter
            extends Converter {
                LeafConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return (JExpression)ConfigInjectorGenerator.this.math.SIMPLE_VALUE_CONVERTER.apply(targetType, (Object)rhs);
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(String.class);
                }

                @Override
                boolean isLeaf() {
                    return true;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    ClassGenerator.this.metadata.add((Object)key, (Object)this.makeCollectionIfNecessary("leaf"));
                }
            }

            abstract class Converter {
                Converter() {
                }

                abstract JExpression as(JExpression var1, TypeMirror var2);

                abstract JClass sourceType();

                abstract boolean isLeaf();

                abstract void addMetadata(String var1, TypeMirror var2);

                protected final String makeCollectionIfNecessary(String s) {
                    if (MethodGenerator.this.packer != null) {
                        return "collection:" + s;
                    }
                    return s;
                }
            }

            final class MapPacker
            extends Packer {
                private JVar $map;
                private final TypeMirror itemT;

                public MapPacker(TypeMirror itemType) {
                    this.itemT = itemType;
                }

                @Override
                TypeMirror itemType() {
                    return this.itemT;
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$map = MethodGenerator.this.var(Map.class, (JExpression)JExpr._new((JClass)ConfigInjectorGenerator.this.cm.ref(HashMap.class)).arg($valueSize));
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression itemDom) {
                    block.invoke((JExpression)this.$map, "put").arg((JExpression)itemDom.invoke("getKey")).arg(item);
                }

                @Override
                JExpression end() {
                    return this.$map;
                }
            }

            final class ListPacker
            extends Packer {
                private JVar $list;
                private final JClass collectionType;
                private final JClass itemType;
                private final TypeMirror itemT;

                public ListPacker(TypeMirror collectionType, TypeMirror itemType) {
                    this.collectionType = ((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(collectionType, null)).boxify();
                    this.itemType = ((JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(itemType, null)).boxify();
                    this.itemT = itemType;
                }

                @Override
                TypeMirror itemType() {
                    return this.itemT;
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$list = MethodGenerator.this.var((JType)this.collectionType, (JExpression)JExpr._new((JType)this.implType()).arg($valueSize));
                }

                JType implType() {
                    if (ConfigInjectorGenerator.this.cm.ref(Set.class).isAssignableFrom(this.collectionType)) {
                        return ConfigInjectorGenerator.this.cm.ref(HashSet.class).narrow(this.itemType);
                    }
                    return ConfigInjectorGenerator.this.cm.ref(ArrayList.class).narrow(this.itemType);
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression sourceValue) {
                    block.invoke((JExpression)this.$list, "add").arg(item);
                }

                @Override
                JExpression end() {
                    return this.$list;
                }
            }

            final class ArrayPacker
            extends Packer {
                private JVar $array;
                private JVar $index;
                private final JType arrayT;
                private final JType componentT;
                private final ArrayType at;

                public ArrayPacker(ArrayType t) {
                    this.at = t;
                    this.componentT = (JType)ConfigInjectorGenerator.this.TO_JTYPE.apply(this.itemType(), null);
                    this.arrayT = this.componentT.array();
                }

                @Override
                TypeMirror itemType() {
                    return this.at.getComponentType();
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$array = MethodGenerator.this.var(this.arrayT, (JExpression)JExpr.newArray((JType)this.componentT, (JExpression)$valueSize));
                    this.$index = MethodGenerator.this.var(Integer.TYPE, JExpr.lit((int)0));
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression sourceValue) {
                    block.assign((JAssignmentTarget)this.$array.component(this.$index.incr()), item);
                }

                @Override
                JExpression end() {
                    return this.$array;
                }
            }

            abstract class Packer {
                Packer() {
                }

                abstract TypeMirror itemType();

                abstract void start(JExpression var1);

                abstract void pack(JBlock var1, JExpression var2, JExpression var3);

                abstract JExpression end();
            }
        }
    }
}

