/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.ServiceFileInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

public class ServiceAnnotationProcessor
extends AbstractProcessor {
    private boolean debug;
    private Map<String, ServiceFileInfo> serviceFiles = new HashMap<String, ServiceFileInfo>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.debug = processingEnv.getOptions().containsKey("-Adebug");
        if (this.debug) {
            this.printNote(processingEnv.getOptions().toString());
        }
        this.loadExistingMetaInfFiles();
    }

    protected void loadExistingMetaInfFiles() {
        String outDirectory = this.processingEnv.getOptions().get("-s");
        if (outDirectory == null) {
            outDirectory = System.getProperty("user.dir");
        }
        File outDir = new File(new File(outDirectory), "META-INF/services").getAbsoluteFile();
        if (this.debug) {
            this.printNote("Output dir is " + outDir.getAbsolutePath());
        }
        if (!outDir.exists()) {
            return;
        }
        for (File file : outDir.listFiles()) {
            if (file.isDirectory()) continue;
            HashSet<String> entries = new HashSet<String>();
            try {
                FileReader reader = new FileReader(file);
                LineNumberReader lineReader = new LineNumberReader(reader);
                String line = lineReader.readLine();
                while (line != null) {
                    entries.add(line);
                    line = lineReader.readLine();
                }
            }
            catch (IOException e) {
                this.printError(e.getMessage());
            }
            ServiceFileInfo info = new ServiceFileInfo(file.getName(), entries);
            this.serviceFiles.put(file.getName(), info);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ListClassVisitor listClassVisitor = new ListClassVisitor();
        ArrayList<TypeElement> classes = new ArrayList<TypeElement>();
        this.filterClasses(classes, roundEnv.getRootElements());
        for (TypeElement typeDecl : classes) {
            typeDecl.accept(listClassVisitor, null);
        }
        for (ServiceFileInfo info : this.serviceFiles.values()) {
            if (!info.isDirty()) continue;
            if (this.debug) {
                this.printNote("Creating META-INF/services " + info.getServiceName() + " file");
            }
            PrintWriter writer = new PrintWriter(info.getWriter());
            for (String implementor : info.getImplementors()) {
                if (this.debug) {
                    this.printNote(" Implementor " + implementor);
                }
                writer.println(implementor);
            }
            writer.close();
        }
        return true;
    }

    private void filterClasses(Collection<TypeElement> classes, Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (!element.getKind().equals((Object)ElementKind.CLASS)) continue;
            classes.add((TypeElement)element);
            this.filterClasses(classes, ElementFilter.typesIn(element.getEnclosedElements()));
        }
    }

    private void createContractImplementation(String contractName, TypeElement impl) {
        ServiceFileInfo info;
        if (!this.serviceFiles.containsKey(contractName)) {
            info = new ServiceFileInfo(contractName, new HashSet<String>());
            this.serviceFiles.put(contractName, info);
        } else {
            info = this.serviceFiles.get(contractName);
        }
        if (info.getImplementors().add(impl.getQualifiedName().toString())) {
            try {
                info.createFile(this.processingEnv);
            }
            catch (IOException ioe) {
                this.printError(ioe.getMessage());
            }
        }
    }

    private void printNote(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private void printError(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private class ListClassVisitor
    extends SimpleElementVisitor6<Void, Void> {
        private ListClassVisitor() {
        }

        @Override
        public Void visitType(TypeElement element, Void aVoid) {
            if (ServiceAnnotationProcessor.this.debug) {
                ServiceAnnotationProcessor.this.printNote("Visiting " + element.getQualifiedName());
            }
            Service service = element.getAnnotation(Service.class);
            if (ServiceAnnotationProcessor.this.debug) {
                ServiceAnnotationProcessor.this.printNote("Service annotation = " + service);
            }
            if (service != null) {
                for (TypeMirror typeMirror : element.getInterfaces()) {
                    this.checkContract((TypeElement)((DeclaredType)typeMirror).asElement(), element);
                }
                TypeElement sd = element;
                while (sd.getSuperclass() != null) {
                    sd = (TypeElement)((DeclaredType)sd.getSuperclass()).asElement();
                    this.checkContract(sd, element);
                }
            } else {
                for (ServiceFileInfo serviceFileInfo : ServiceAnnotationProcessor.this.serviceFiles.values()) {
                    if (ServiceAnnotationProcessor.this.debug) {
                        ServiceAnnotationProcessor.this.printNote("Checking against " + serviceFileInfo.getServiceName());
                    }
                    for (String implementor : serviceFileInfo.getImplementors()) {
                        if (!implementor.equals(element.getQualifiedName().toString())) continue;
                        if (ServiceAnnotationProcessor.this.debug) {
                            ServiceAnnotationProcessor.this.printNote("Need to remove " + implementor);
                        }
                        serviceFileInfo.getImplementors().remove(implementor);
                        try {
                            serviceFileInfo.createFile(ServiceAnnotationProcessor.this.processingEnv);
                        }
                        catch (IOException ioe) {
                            ServiceAnnotationProcessor.this.printError(ioe.getMessage());
                        }
                        return null;
                    }
                }
            }
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                TypeElement atd = (TypeElement)annotationMirror.getAnnotationType().asElement();
                Contract c = atd.getAnnotation(Contract.class);
                if (c == null) continue;
                ServiceAnnotationProcessor.this.createContractImplementation(atd.getQualifiedName().toString(), element);
            }
            return null;
        }

        private void checkContract(TypeElement type, TypeElement impl) {
            Contract contract = type.getAnnotation(Contract.class);
            if (contract != null) {
                ServiceAnnotationProcessor.this.createContractImplementation(type.getQualifiedName().toString(), impl);
            }
        }
    }
}

