/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.provider.internal;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.AbstractInhabitantProvider;
import com.sun.hk2.component.InhabitantStore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantProviderInterceptor;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.provider.internal.ConfigByMetaInhabitant;

public class ConfigInhabitantProvider
extends AbstractInhabitantProvider {
    private static final Logger logger = Logger.getLogger(ConfigInhabitantProvider.class.getName());
    private final Habitat habitat;

    public ConfigInhabitantProvider(Habitat h) {
        this.habitat = h;
    }

    public AbstractInhabitantImpl<?> visit(AbstractInhabitantImpl<?> i, String typeName, Set<String> indicies, Iterator<InhabitantProviderInterceptor> remainingInterceptors, InhabitantStore store) {
        boolean shouldProcess = false;
        AbstractInhabitantImpl originalInh = i;
        if (ConfigInhabitantProvider.contains(indicies, (String)ConfiguredBy.class.getName())) {
            logger.log(Level.FINE, "Found an @ConfiguredBy inhabitant: {0} with indicies {1}", new Object[]{i, indicies});
            ConfiguredBy cb = (ConfiguredBy)i.getAnnotation(ConfiguredBy.class);
            Class<?> configuredClass = cb.value();
            if (null == configuredClass) {
                throw new ComponentException("ConfiguredBy.value() is required");
            }
            Configured c = configuredClass.getAnnotation(Configured.class);
            if (null == c) {
                throw new ComponentException(i + " service implementation needs to be @Configured");
            }
            HashSet<String> newIndicies = new HashSet<String>(indicies);
            boolean removed = newIndicies.remove(ConfiguredBy.class.getName());
            assert (removed);
            i = new ConfigByMetaInhabitant(this.habitat, (Inhabitant)i, cb, newIndicies);
            shouldProcess = true;
        }
        InhabitantProviderInterceptor next = remainingInterceptors.hasNext() ? remainingInterceptors.next() : null;
        Object object = i = null == next ? i : next.visit(i, typeName, indicies, remainingInterceptors, store);
        if (shouldProcess) {
            if (null == i || null == store) {
                logger.log(Level.FINE, "expected to store inhabitant but couldn't - {0}", originalInh);
            } else {
                store.add((Inhabitant)i);
                store.addIndex((Inhabitant)i, ConfiguredBy.class.getName(), null);
                i = null;
            }
        }
        return i;
    }
}

