/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class HK2GenerateMojo
extends AbstractMojo {
    private static final String META_INF = "META-INF";
    private static final String HK2_LOCATOR = "hk2-locator";
    private static final String DEFAULT = "default";
    private static final String JAR_ENTRY = "META-INF/hk2-locator/default";
    private static final int BUFFER_SIZE = 4096;
    protected File manifestLocation;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        if (dependencyArtifacts == null) {
            return;
        }
        try {
            OutputStream catStream = this.getCatOutputStream();
            for (Artifact a : this.project.getDependencyArtifacts()) {
                if (a.getScope() != null && a.getScope().equals("test")) continue;
                this.getLog().info((CharSequence)("Dependency Artifact: " + a.getFile().toString()));
                JarFile jf = new JarFile(a.getFile());
                JarEntry je = jf.getJarEntry(JAR_ENTRY);
                if (je == null) continue;
                this.getLog().debug((CharSequence)("Dependency Artifact " + a + " has Inhabitants File: " + je));
                this.catJarEntry(jf, je, catStream);
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private void catJarEntry(JarFile jf, JarEntry e, OutputStream catStream) throws IOException {
        int readLength;
        byte[] buf = new byte[4096];
        InputStream is = jf.getInputStream(e);
        while ((readLength = is.read(buf)) > 0) {
            catStream.write(buf, 0, readLength);
        }
    }

    private OutputStream getCatOutputStream() throws MojoExecutionException, IOException {
        String inhabitantsDir = "" + this.manifestLocation + File.separatorChar + META_INF + File.separatorChar + HK2_LOCATOR;
        File inhabitantsDirFile = new File(inhabitantsDir);
        if (inhabitantsDirFile.exists()) {
            if (!inhabitantsDirFile.isDirectory()) {
                throw new MojoExecutionException("File " + inhabitantsDirFile.getAbsolutePath() + " is not a directory");
            }
        } else {
            boolean success = inhabitantsDirFile.mkdirs();
            if (!success) {
                throw new MojoExecutionException("Unable to created directory " + inhabitantsDirFile.getAbsolutePath());
            }
        }
        File defaultFile = new File(inhabitantsDirFile, DEFAULT);
        FileOutputStream fos = new FileOutputStream(defaultFile, true);
        return fos;
    }
}

