/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.internal.ReflectionHelper;

public abstract class AbstractActiveDescriptor<T>
implements ActiveDescriptor<T> {
    private final Set<Type> advertisedContracts;
    private final Set<String> contractsAsStrings = new HashSet<String>();
    private final Class<? extends Annotation> scope;
    private final String name;
    private final Set<Annotation> qualifiers;
    private final Set<String> qualifiersAsStrings = new HashSet<String>();
    private final DescriptorType descriptorType;
    private int ranking;

    protected AbstractActiveDescriptor(Set<Type> advertisedContracts, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, DescriptorType descriptorType, int ranking) {
        this.scope = scope;
        this.advertisedContracts = Collections.unmodifiableSet(advertisedContracts);
        this.qualifiers = Collections.unmodifiableSet(qualifiers);
        this.ranking = ranking;
        this.descriptorType = descriptorType;
        this.name = name;
        for (Type t : advertisedContracts) {
            Class<?> raw = ReflectionHelper.getRawClass(t);
            if (raw == null) continue;
            this.contractsAsStrings.add(raw.getName());
        }
        for (Annotation q : qualifiers) {
            this.qualifiersAsStrings.add(q.annotationType().getName());
        }
    }

    @Override
    public Set<String> getAdvertisedContracts() {
        return Collections.unmodifiableSet(this.contractsAsStrings);
    }

    @Override
    public String getScope() {
        return this.scope.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getLocatorId() {
        return null;
    }

    @Override
    public Set<String> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiersAsStrings);
    }

    @Override
    public DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    @Override
    public Map<String, List<String>> getMetadata() {
        return Collections.emptyMap();
    }

    @Override
    public HK2Loader getLoader() {
        return null;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public int setRanking(int ranking) {
        int retVal = this.ranking;
        this.ranking = ranking;
        return retVal;
    }

    @Override
    public Long getServiceId() {
        return null;
    }

    @Override
    public T getCache() {
        return null;
    }

    @Override
    public boolean isCacheSet() {
        return false;
    }

    @Override
    public void setCache(T cacheMe) {
    }

    @Override
    public void releaseCache() {
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public Set<Type> getContractTypes() {
        return this.advertisedContracts;
    }

    @Override
    public Class<? extends Annotation> getScopeAnnotation() {
        return this.scope;
    }

    @Override
    public Set<Annotation> getQualifierAnnotations() {
        return this.qualifiers;
    }

    @Override
    public List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    @Override
    public void dispose(T instance) {
    }
}

