/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.internal.PerThreadContext;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;

public abstract class ServiceLocatorUtilities {
    private static final String DEFAULT_LOCATOR_NAME = "default";

    public static void enablePerThreadScope(ServiceLocator locator) {
        Context perThreadContext = (Context)locator.getService(new TypeLiteral<Context<PerThread>>(){}.getType(), new Annotation[0]);
        if (perThreadContext != null) {
            return;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.bind(BuilderHelper.link(PerThreadContext.class).to(Context.class).in(Singleton.class.getName()).build());
        config.commit();
    }

    public static void bind(ServiceLocator locator, Binder ... binders) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        for (Binder binder : binders) {
            binder.bind(config);
        }
        config.commit();
    }

    public static ServiceLocator bind(String name, Binder ... binders) {
        ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
        ServiceLocator locator = factory.create(name);
        ServiceLocatorUtilities.bind(locator, binders);
        return locator;
    }

    public static ServiceLocator bind(Binder ... binders) {
        return ServiceLocatorUtilities.bind(DEFAULT_LOCATOR_NAME, binders);
    }

    public static ActiveDescriptor<?> addOneDescriptor(ServiceLocator locator, Descriptor descriptor) {
        ActiveDescriptor active;
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService((Type)((Object)DynamicConfigurationService.class), new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        ActiveDescriptor<Object> retVal = descriptor instanceof ActiveDescriptor ? ((active = (ActiveDescriptor)descriptor).isReified() ? config.addActiveDescriptor(active) : config.bind(descriptor)) : config.bind(descriptor);
        config.commit();
        return retVal;
    }
}

