/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.utilities.reflection.Pretty;

public class InjecteeImpl
implements Injectee,
Serializable {
    private static final long serialVersionUID = -1501119884265443727L;
    private Type requiredType;
    private Set<Annotation> qualifiers;
    private int position;
    private Class<?> pClass;
    private AnnotatedElement parent;
    private boolean isOptional;
    private boolean isSelf;
    private Unqualified unqualified;

    public InjecteeImpl() {
    }

    public InjecteeImpl(Injectee copyMe) {
        this.requiredType = copyMe.getRequiredType();
        this.position = copyMe.getPosition();
        this.parent = copyMe.getParent();
        this.qualifiers = Collections.unmodifiableSet(copyMe.getRequiredQualifiers());
        this.isOptional = copyMe.isOptional();
        this.isSelf = copyMe.isSelf();
        this.pClass = this.parent instanceof Field ? ((Field)this.parent).getDeclaringClass() : (this.parent instanceof Constructor ? ((Constructor)this.parent).getDeclaringClass() : ((Method)this.parent).getDeclaringClass());
    }

    @Override
    public Type getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(Type requiredType) {
        this.requiredType = requiredType;
    }

    @Override
    public Set<Annotation> getRequiredQualifiers() {
        return this.qualifiers;
    }

    public void setRequiredQualifiers(Set<Annotation> requiredQualifiers) {
        this.qualifiers = Collections.unmodifiableSet(requiredQualifiers);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public Class<?> getInjecteeClass() {
        return this.pClass;
    }

    @Override
    public AnnotatedElement getParent() {
        return this.parent;
    }

    public void setParent(AnnotatedElement parent) {
        this.parent = parent;
        this.pClass = parent instanceof Field ? ((Field)parent).getDeclaringClass() : (parent instanceof Constructor ? ((Constructor)parent).getDeclaringClass() : ((Method)parent).getDeclaringClass());
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean optional) {
        this.isOptional = optional;
    }

    @Override
    public boolean isSelf() {
        return this.isSelf;
    }

    public void setSelf(boolean self) {
    }

    public Unqualified getUnqualified() {
        return this.unqualified;
    }

    public void setUnqualified(Unqualified unqualified) {
        this.unqualified = unqualified;
    }

    public String toString() {
        return "InjecteeImpl(requiredType=" + Pretty.type((Type)this.requiredType) + ",parent=" + Pretty.clazz(this.pClass) + ",qualifiers=" + Pretty.collection(this.qualifiers) + ",position=" + this.position + ",optional=" + this.isOptional + ",self=" + this.isSelf + ",unqualified=" + this.unqualified + "," + System.identityHashCode(this) + ")";
    }
}

